package de.sldw.composeonboarding

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.animation.EnterTransition
import androidx.compose.animation.ExitTransition
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.BoxScope
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.alpha
import androidx.compose.ui.semantics.hideFromAccessibility
import androidx.compose.ui.semantics.semantics
import androidx.compose.ui.zIndex

@Composable
internal fun AnimatedVisibilityBlockingSpace(
    visible: Boolean,
    enter: EnterTransition,
    exit: ExitTransition,
    zIndex: Float = 0f,
    content: @Composable BoxScope.(visible: Boolean) -> Unit
) {
    Box(modifier = Modifier.zIndex(zIndex)) {
        // Dummy view for keeping the space
        Box(
            modifier = Modifier
                .zIndex(-1f)
                .alpha(0f)
                .semantics {
                    hideFromAccessibility()
                }
        ) {
            content(false)
        }

        // Real animated view, which gets shown to the user
        AnimatedVisibility(
            visible = visible,
            enter = enter,
            exit = exit
        ) {
            Box {
                content(true)
            }
        }
    }
}