package de.sldw.composeonboarding.indicator

import androidx.compose.animation.animateColorAsState
import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.size
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Circle
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.unit.dp

data class DotIndicator(
    val selectedColor: @Composable () -> Color = { MaterialTheme.colorScheme.primary },
    val deselectedColor: @Composable () -> Color = { MaterialTheme.colorScheme.inversePrimary }
) : IndicatorType {
    @Composable
    override fun Content(currentPage: Int, maxPages: Int) {
        Row {
            for (i in 0 until maxPages) {
                val isCurrentPage = i == currentPage
                val animatedColor by animateColorAsState(
                    if (isCurrentPage) selectedColor() else deselectedColor(),
                    label = "color"
                )

                Image(
                    modifier = Modifier.size(20.dp),
                    imageVector = Icons.Default.Circle,
                    contentDescription = null,
                    colorFilter = ColorFilter.tint(animatedColor)
                )
            }
        }
    }
}