package de.sldw.composeonboarding

import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue

abstract class OnboardingPage {
    internal var mCanNavigateNext by mutableStateOf(true)

    private var isVisible = false

    @Composable
    abstract fun Content(paddingValues: PaddingValues)

    open fun onAppear() {}
    open fun onDisappear() {}

    internal fun mOnAppear() {
        if (isVisible.not()) {
            onAppear()
            isVisible = true
        }
    }

    internal fun mOnDisappear() {
        if (isVisible) {
            onDisappear()
            isVisible = false
        }
    }
}
