/*
 * Decompiled with CFR 0.152.
 */
package de.sldk.kotbar;

import de.sldk.kotbar.DefaultProgressBar;
import de.sldk.kotbar.ProgressBar;
import de.sldk.kotbar.ProgressStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0011R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/sldk/kotbar/Kotbar;", "", "size", "", "width", "", "title", "", "progressBar", "Lde/sldk/kotbar/ProgressBar;", "(JILjava/lang/String;Lde/sldk/kotbar/ProgressBar;)V", "failure", "", "finished", "progress", "progressDone", "done", "", "drawProgressBar", "fail", "inc", "kotbar"})
public final class Kotbar {
    private long progress;
    private long progressDone;
    private boolean finished;
    private boolean failure;
    private final long size;
    private final int width;
    private final String title;
    private final ProgressBar progressBar;

    public final void inc() {
        if (this.finished) {
            return;
        }
        if (this.progress == 0L && this.title != null) {
            System.out.println(this.progressBar.formatTitle(this.title));
        }
        long l = this.progress;
        this.progress = l + 1L;
        l = this.progressDone;
        this.progressDone = l + 1L;
        this.drawProgressBar();
    }

    public final void done() {
        if (!this.finished) {
            String string = "\n";
            System.out.print((Object)string);
            this.finished = true;
        }
    }

    public final void fail() {
        if (!this.finished) {
            this.progress = this.size;
            this.failure = true;
            this.drawProgressBar();
            this.done();
        }
    }

    private final void drawProgressBar() {
        Object object;
        int b;
        int it2;
        StringBuilder stringBuilder;
        boolean finished;
        double decimalProgress = (double)this.progress / (double)this.size;
        int percentage = MathKt.roundToInt((double)(decimalProgress * (double)100));
        boolean bl = finished = percentage == 100;
        ProgressStatus status = this.failure ? ProgressStatus.FAILED : (finished ? ProgressStatus.DONE : ProgressStatus.IN_PROGRESS);
        int progressedBlocks = MathKt.roundToInt((double)(decimalProgress * (double)this.width));
        int remainingBlocks = this.width - progressedBlocks;
        String color = this.progressBar.getColor(status);
        StringBuilder $receiver = stringBuilder = new StringBuilder("\r");
        $receiver.append(color);
        $receiver.append(StringsKt.padEnd$default((String)("" + percentage + '%'), (int)4, (char)'\u0000', (int)2, null));
        $receiver.append(" ");
        Object object2 = this.progressBar.getBorders();
        if (object2 != null && (object2 = (String)object2.getFirst()) != null) {
            Object object3;
            Object it2 = object3 = object2;
            $receiver.append((String)it2);
        }
        int n = 1;
        int n2 = it2 = finished ? progressedBlocks : progressedBlocks - 1;
        if (n <= it2) {
            while (true) {
                $receiver.append(this.progressBar.getDoneBlock());
                if (b == it2) break;
                ++b;
            }
        }
        if (!finished) {
            $receiver.append(this.progressBar.getArrowBlock());
        }
        if ((b = 1) <= (it2 = remainingBlocks)) {
            while (true) {
                $receiver.append(this.progressBar.getRemainingBlock());
                if (b == it2) break;
                ++b;
            }
        }
        if ((object = this.progressBar.getBorders()) != null && (object = (String)object.getSecond()) != null) {
            Object object4;
            Object it3 = object4 = object;
            $receiver.append((String)it3);
        }
        $receiver.append(" ").append(this.progressBar.getInfoBlock(percentage, this.progressDone, this.size, status));
        String bar = $receiver.append("\u001b[0m").toString();
        System.out.print(bar);
    }

    public Kotbar(long size, int width, @Nullable String title, @NotNull ProgressBar progressBar) {
        Intrinsics.checkParameterIsNotNull((Object)progressBar, (String)"progressBar");
        this.size = size;
        this.width = width;
        this.title = title;
        this.progressBar = progressBar;
        this.progressDone = this.progress;
    }

    public /* synthetic */ Kotbar(long l, int n, String string, ProgressBar progressBar, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 100;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            progressBar = new DefaultProgressBar(null, 1, null);
        }
        this(l, n, string, progressBar);
    }
}

