/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.util;

import de.skuzzle.tinyplugz.util.Require;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RequireTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testRequireNull() throws Exception {
        Object obj = new Object();
        Assert.assertSame((Object)obj, (Object)Require.nonNull((Object)obj, (String)"foo"));
    }

    @Test
    public void testNonNullWithNullValue() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("'foo' must not be null");
        Require.nonNull(null, (String)"foo");
    }

    @Test
    public void testNonNullWithNullValueAndNullName() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("'null' must not be null");
        Require.nonNull(null, null);
    }

    @Test
    public void testConditionWithFalseCondition() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("foo bar");
        Require.condition((boolean)false, (String)"foo %s", (Object[])new Object[]{"bar"});
    }

    @Test
    public void testConditionWithTrueCondition() throws Exception {
        Require.condition((boolean)true, (String)"foo", (Object[])new Object[]{"bar"});
    }

    @Test
    public void testStateWithFalseCondition() throws Exception {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("foo bar");
        Require.state((boolean)false, (String)"foo %s", (Object[])new Object[]{"bar"});
    }

    @Test
    public void testStateWithTrueCondition() throws Exception {
        Require.state((boolean)true, (String)"foo", (Object[])new Object[]{"bar"});
    }

    @Test
    public void testNonNullResultWithNonNullValue() throws Exception {
        Object obj = new Object();
        Assert.assertSame((Object)obj, (Object)Require.nonNullResult((Object)obj, (String)""));
    }

    @Test
    public void testNonNullResultWithNullValue() throws Exception {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("call of 'foo' yielded unexpected null value");
        Require.nonNullResult(null, (String)"foo");
    }

    @Test
    public void testNonNullResultWithNullValueAndNullName() throws Exception {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("call of 'null' yielded unexpected null value");
        Require.nonNullResult(null, null);
    }
}

