/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.util;

import de.skuzzle.tinyplugz.util.ElementIterator;
import de.skuzzle.tinyplugz.util.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class IteratorsTest {
    @Test(expected=IllegalArgumentException.class)
    public void testCompositeNullIterator() {
        Iterators.composite((Iterator[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCompositeNullIterable() {
        Iterators.composite((Iterable[])null);
    }

    @Test
    public void testCompositeIterables() throws Exception {
        List<String> first = Arrays.asList("a", "b");
        List<String> second = Arrays.asList("c", "d");
        Iterable wrapped = Iterators.composite((Iterable[])new Iterable[]{first, second});
        Iterator it = wrapped.iterator();
        Assert.assertEquals((Object)"a", it.next());
        Assert.assertEquals((Object)"b", it.next());
        Assert.assertEquals((Object)"c", it.next());
        Assert.assertEquals((Object)"d", it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testCompositeSingleIterable() throws Exception {
        List it = Collections.emptyList();
        Assert.assertSame(it, (Object)Iterators.composite((Iterable[])new Iterable[]{it}));
    }

    @Test
    public void testAllEmpty() {
        ArrayList v = new ArrayList();
        Iterator[] enums = new Iterator[]{v.iterator(), v.iterator(), v.iterator()};
        ElementIterator ce = Iterators.composite((Iterator[])enums);
        Assert.assertFalse((boolean)ce.hasNext());
    }

    @Test
    public void testEmptyArray() {
        Iterator[] enums = new Iterator[]{};
        ElementIterator ce = Iterators.composite((Iterator[])enums);
        Assert.assertFalse((boolean)ce.hasNext());
    }

    @Test
    public void testMiddleIsEmpty() {
        ArrayList empty = new ArrayList();
        List<String> oneElement = Arrays.asList("foo");
        Iterator[] enums = new Iterator[]{oneElement.iterator(), empty.iterator(), oneElement.iterator()};
        ElementIterator ce = Iterators.composite((Iterator[])enums);
        Assert.assertEquals((Object)"foo", ce.next());
        Assert.assertTrue((boolean)ce.hasNext());
        Assert.assertEquals((Object)"foo", ce.next());
        Assert.assertFalse((boolean)ce.hasNext());
    }

    @Test
    public void testFirstIsEmpty() {
        ArrayList empty = new ArrayList();
        List<String> oneElement = Arrays.asList("foo");
        Iterator[] enums = new Iterator[]{empty.iterator(), oneElement.iterator(), oneElement.iterator()};
        ElementIterator ce = Iterators.composite((Iterator[])enums);
        Assert.assertEquals((Object)"foo", ce.next());
        Assert.assertTrue((boolean)ce.hasNext());
        Assert.assertEquals((Object)"foo", ce.next());
        Assert.assertFalse((boolean)ce.hasNext());
    }

    @Test
    public void testLastIsEmpty() {
        ArrayList empty = new ArrayList();
        List<String> oneElement = Arrays.asList("foo");
        Iterator[] enums = new Iterator[]{oneElement.iterator(), oneElement.iterator(), empty.iterator()};
        ElementIterator ce = Iterators.composite((Iterator[])enums);
        Assert.assertEquals((Object)"foo", ce.next());
        Assert.assertTrue((boolean)ce.hasNext());
        Assert.assertEquals((Object)"foo", ce.next());
        Assert.assertFalse((boolean)ce.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void testNoSuchElementException() {
        Iterator[] enums = new Iterator[]{};
        ElementIterator ce = Iterators.composite((Iterator[])enums);
        ce.next();
    }
}

