/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.util;

import de.skuzzle.tinyplugz.PluginSourceBuilder;
import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.TinyPlugzConfigurator;
import de.skuzzle.tinyplugz.util.ExchangeClassLoader;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ExchangeClassLoaderTest {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private TinyPlugz tinyPlugz;
    @Mock
    private ClassLoader classLoaderMock;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.tinyPlugz.getClassLoader()).thenReturn((Object)this.classLoaderMock);
        TinyPlugzConfigurator.setup().withProperty("tinyplugz.forceImplementation", (Object)this.tinyPlugz).withPlugins(PluginSourceBuilder::noPlugins).deploy();
    }

    @After
    public void tearDown() {
        if (TinyPlugz.isDeployed()) {
            TinyPlugz.getInstance().undeploy();
        }
    }

    @Test
    public void testExchange() throws Exception {
        ClassLoader realClassLoader = Thread.currentThread().getContextClassLoader();
        try (ExchangeClassLoader exchange = ExchangeClassLoader.forTinyPlugz();){
            Assert.assertSame((Object)this.classLoaderMock, (Object)Thread.currentThread().getContextClassLoader());
        }
        Assert.assertSame((Object)realClassLoader, (Object)Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void testExchangeNoTinyPlugz() throws Exception {
        TinyPlugz.getInstance().undeploy();
        ExchangeClassLoader exchange = ExchangeClassLoader.forTinyPlugz();
        Throwable throwable = null;
        if (exchange != null) {
            if (throwable != null) {
                try {
                    exchange.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                exchange.close();
            }
        }
    }

    @Test
    public void testExchangeAndRestoreOnException() throws Exception {
        ClassLoader realClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ExchangeClassLoader exchange = ExchangeClassLoader.forTinyPlugz();
            Throwable throwable = null;
            try {
                try {
                    throw new IOException();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (exchange != null) {
                    if (throwable != null) {
                        try {
                            exchange.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        exchange.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException iOException) {
            Assert.assertSame((Object)realClassLoader, (Object)Thread.currentThread().getContextClassLoader());
            return;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testDiscoverExchange() throws Exception {
        try (ExchangeClassLoader exchange = ExchangeClassLoader.forTinyPlugz();){
            exchange.setFailOnChange(true);
            ClassLoader someClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
            Thread.currentThread().setContextClassLoader(someClassLoader);
        }
    }

    @Test
    public void testDiscoverNoExchange() throws Exception {
        try (ExchangeClassLoader exchange = ExchangeClassLoader.forTinyPlugz();){
            exchange.setFailOnChange(true);
        }
    }
}

