/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.servlet;

import de.skuzzle.tinyplugz.PluginSourceBuilder;
import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.TinyPlugzConfigurator;
import de.skuzzle.tinyplugz.servlet.TinyPlugzContextServlet;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TinyPlugzContextServletTest {
    @Mock
    private Servlet mockServlet;
    @Mock
    private ServletRequest request;
    @Mock
    private ServletResponse response;
    @Mock
    private ServletConfig config;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private TinyPlugz tinyPlugz;
    @Mock
    private ClassLoader classLoader;
    private Servlet servlet;
    private Servlet subject;

    @Before
    public void setUp() throws Exception {
        TinyPlugzConfigurator.setup().withProperty("tinyplugz.forceImplementation", (Object)this.tinyPlugz).withPlugins(PluginSourceBuilder::noPlugins).deploy();
        Mockito.when((Object)this.tinyPlugz.getClassLoader()).thenReturn((Object)this.classLoader);
        Mockito.when((Object)this.mockServlet.getServletConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.mockServlet.getServletInfo()).thenReturn((Object)"info");
        this.servlet = new Servlet(){

            public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                Assert.assertEquals((Object)TinyPlugzContextServletTest.this.classLoader, (Object)Thread.currentThread().getContextClassLoader());
            }

            public void init(ServletConfig config) throws ServletException {
                Assert.assertEquals((Object)TinyPlugzContextServletTest.this.classLoader, (Object)Thread.currentThread().getContextClassLoader());
            }

            public String getServletInfo() {
                return null;
            }

            public ServletConfig getServletConfig() {
                return null;
            }

            public void destroy() {
                Assert.assertEquals((Object)TinyPlugzContextServletTest.this.classLoader, (Object)Thread.currentThread().getContextClassLoader());
            }
        };
    }

    @After
    public void tearDown() {
        TinyPlugz.getInstance().undeploy();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrapNull() throws Exception {
        TinyPlugzContextServlet.wrap(null);
    }

    @Test
    public void testWrapContextServlet() throws Exception {
        this.subject = TinyPlugzContextServlet.wrap((Servlet)this.mockServlet);
        Servlet wrapAgain = TinyPlugzContextServlet.wrap((Servlet)this.subject);
        Assert.assertSame((Object)this.subject, (Object)wrapAgain);
    }

    @Test
    public void testInitCalled() throws Exception {
        this.subject = TinyPlugzContextServlet.wrap((Servlet)this.mockServlet);
        this.subject.init(this.config);
        ((Servlet)Mockito.verify((Object)this.mockServlet)).init(this.config);
    }

    @Test
    public void testInitCorrectContext() throws Exception {
        this.subject = TinyPlugzContextServlet.wrap((Servlet)this.servlet);
        this.subject.init(this.config);
    }

    @Test
    public void testServiceCalled() throws Exception {
        this.subject = TinyPlugzContextServlet.wrap((Servlet)this.mockServlet);
        this.subject.service(this.request, this.response);
        ((Servlet)Mockito.verify((Object)this.mockServlet)).service(this.request, this.response);
    }

    @Test
    public void testServiceCorrectContext() throws Exception {
        this.subject = TinyPlugzContextServlet.wrap((Servlet)this.servlet);
        this.subject.service(this.request, this.response);
    }

    @Test
    public void testDestroyCalled() throws Exception {
        this.subject = TinyPlugzContextServlet.wrap((Servlet)this.mockServlet);
        this.subject.destroy();
        ((Servlet)Mockito.verify((Object)this.mockServlet)).destroy();
    }

    @Test
    public void testDestroyCorrectContext() throws Exception {
        this.subject = TinyPlugzContextServlet.wrap((Servlet)this.servlet);
        this.subject.destroy();
    }

    @Test
    public void testGetConfigCalled() throws Exception {
        this.subject = TinyPlugzContextServlet.wrap((Servlet)this.mockServlet);
        Assert.assertSame((Object)this.config, (Object)this.subject.getServletConfig());
    }

    @Test
    public void testInfoCalled() throws Exception {
        this.subject = TinyPlugzContextServlet.wrap((Servlet)this.mockServlet);
        Assert.assertEquals((Object)"info", (Object)this.subject.getServletInfo());
    }
}

