/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.internal;

import de.skuzzle.tinyplugz.DeployListener;
import de.skuzzle.tinyplugz.PluginInformation;
import de.skuzzle.tinyplugz.PluginSource;
import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.TinyPlugzException;
import de.skuzzle.tinyplugz.internal.DefaultTinyPlugz;
import de.skuzzle.tinyplugz.internal.TinyPlugzLookUp;
import de.skuzzle.tinyplugz.test.util.MockUtil;
import de.skuzzle.tinyplugz.util.ElementIterator;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServiceLoader.class, MockUtil.class, TinyPlugzLookUp.class})
public class TinyPlugzLookUpTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testDefaultStrategy() throws Exception {
        TinyPlugz inst = TinyPlugzLookUp.DEFAULT_INSTANCE_STRATEGY.getInstance(null, null);
        Assert.assertTrue((boolean)(inst instanceof DefaultTinyPlugz));
    }

    @Test
    public void testStaticStrategyWithClassName() throws Exception {
        String implName = SampleTinyPlugzImpl.class.getName();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("tinyplugz.forceImplementation", implName);
        TinyPlugz inst = TinyPlugzLookUp.STATIC_STRATEGY.getInstance(this.getClass().getClassLoader(), props);
        Assert.assertTrue((boolean)(inst instanceof SampleTinyPlugzImpl));
    }

    @Test
    public void testStaticStrategyWithClass() throws Exception {
        HashMap<String, Class<SampleTinyPlugzImpl>> props = new HashMap<String, Class<SampleTinyPlugzImpl>>();
        props.put("tinyplugz.forceImplementation", SampleTinyPlugzImpl.class);
        TinyPlugz inst = TinyPlugzLookUp.STATIC_STRATEGY.getInstance(this.getClass().getClassLoader(), props);
        Assert.assertTrue((boolean)(inst instanceof SampleTinyPlugzImpl));
    }

    @Test
    public void testStaticStrategyWithImpl() throws Exception {
        SampleTinyPlugzImpl expected = new SampleTinyPlugzImpl();
        HashMap<String, SampleTinyPlugzImpl> props = new HashMap<String, SampleTinyPlugzImpl>();
        props.put("tinyplugz.forceImplementation", expected);
        TinyPlugz inst = TinyPlugzLookUp.STATIC_STRATEGY.getInstance(this.getClass().getClassLoader(), props);
        Assert.assertSame((Object)((Object)expected), (Object)inst);
    }

    @Test(expected=TinyPlugzException.class)
    public void testStaticStrategyWrongType() throws Exception {
        String implName = Object.class.getName();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("tinyplugz.forceImplementation", implName);
        TinyPlugzLookUp.STATIC_STRATEGY.getInstance(this.getClass().getClassLoader(), props);
    }

    @Test
    public void testSPIStrategy() throws Exception {
        TinyPlugz mock1 = (TinyPlugz)Mockito.mock(TinyPlugz.class);
        TinyPlugz mock2 = (TinyPlugz)Mockito.mock(TinyPlugz.class);
        MockUtil.mockService(TinyPlugz.class, mock1, mock2);
        TinyPlugz inst = TinyPlugzLookUp.SPI_STRATEGY.getInstance(this.getClass().getClassLoader(), Collections.emptyMap());
        Assert.assertSame((Object)mock1, (Object)inst);
    }

    @Test
    public void testSPIStrategyDefaultFallBack() throws Exception {
        MockUtil.mockService(TinyPlugz.class, new TinyPlugz[0]);
        TinyPlugz inst = TinyPlugzLookUp.SPI_STRATEGY.getInstance(this.getClass().getClassLoader(), null);
        Assert.assertTrue((boolean)(inst instanceof DefaultTinyPlugz));
    }

    @Test(expected=TinyPlugzException.class)
    public void testSPIStrategyWithFail() throws Exception {
        TinyPlugz mock1 = (TinyPlugz)Mockito.mock(TinyPlugz.class);
        TinyPlugz mock2 = (TinyPlugz)Mockito.mock(TinyPlugz.class);
        MockUtil.mockService(TinyPlugz.class, mock1, mock2);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("tinyplugz.failOnMultipleProviders", "true");
        TinyPlugzLookUp.SPI_STRATEGY.getInstance(this.getClass().getClassLoader(), props);
    }

    static final class SampleTinyPlugzImpl
    extends TinyPlugz {
        SampleTinyPlugzImpl() {
        }

        protected void initialize(PluginSource source, ClassLoader parentClassLoader, Map<Object, Object> properties) throws TinyPlugzException {
        }

        protected Iterator<DeployListener> findDeployListeners(ClassLoader pluginClassLoader) {
            return null;
        }

        public Collection<PluginInformation> getPluginInformation() {
            return null;
        }

        public void runMain(String className, String[] args) throws TinyPlugzException {
        }

        public ClassLoader getClassLoader() {
            return null;
        }

        public Optional<URL> getResource(String name) {
            return null;
        }

        public ElementIterator<URL> getResources(String name) throws IOException {
            return null;
        }

        public <T> ElementIterator<T> getServices(Class<T> type) {
            return null;
        }

        public <T> Optional<T> getFirstService(Class<T> type) {
            return null;
        }

        public <T> T getService(Class<T> type) {
            return null;
        }

        protected void dispose() {
        }
    }
}

