/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.internal;

import de.skuzzle.tinyplugz.internal.PluginSourceBuilderImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Files.class, PluginSourceBuilderImpl.class, PluginSourceBuilderImplTest.class})
public class PluginSourceBuilderImplTest {
    private PluginSourceBuilderImpl subject;
    private int pathCounter;

    @Before
    public void setUp() throws Exception {
        this.subject = new PluginSourceBuilderImpl();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddUnpackedNull() throws Exception {
        this.subject.addUnpackedPlugin(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddUnpackedNotADirectory() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        PowerMockito.mockStatic(Files.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Files.isDirectory(path, new LinkOption[0])).thenReturn((Object)false);
        this.subject.addUnpackedPlugin(path);
    }

    @Test
    public void testAddUnpackedPlugin() throws Exception {
        Path path = this.mockPath();
        PowerMockito.mockStatic(Files.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Files.isDirectory(path, new LinkOption[0])).thenReturn((Object)true);
        Assert.assertNotNull((Object)this.subject.addUnpackedPlugin(path));
        Assert.assertEquals((long)1L, (long)this.subject.createSource().getPluginURLs().count());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddPluginjarNull() throws Exception {
        this.subject.addPluginJar(null);
    }

    @Test
    public void testAddPluginJar() throws Exception {
        Path path = this.mockPath();
        Assert.assertNotNull((Object)this.subject.addPluginJar(path));
        Assert.assertEquals((long)1L, (long)this.subject.createSource().getPluginURLs().count());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddPluginJarsNullFolder() throws Exception {
        this.subject.addAllPluginJars(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddPluginJarsNullFilter() throws Exception {
        this.subject.addAllPluginJars((Path)Mockito.mock(Path.class), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddPluginJarsNotADirectory() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        PowerMockito.mockStatic(Files.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Files.isDirectory(path, new LinkOption[0])).thenReturn((Object)false);
        this.subject.addAllPluginJars((Path)Mockito.mock(Path.class), null);
    }

    @Test
    @Ignore
    public void testAddPluginJars() throws Exception {
    }

    private Path mockPath() throws MalformedURLException {
        Path path = (Path)PowerMockito.mock(Path.class);
        URI uri = (URI)PowerMockito.mock(URI.class);
        URL url = (URL)PowerMockito.mock(URL.class);
        String name = "url_" + this.pathCounter++;
        Path fileName = (Path)PowerMockito.mock(Path.class);
        Mockito.when((Object)fileName.toString()).thenReturn((Object)name);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)fileName);
        Mockito.when((Object)path.toUri()).thenReturn((Object)uri);
        Mockito.when((Object)uri.toURL()).thenReturn((Object)url);
        Mockito.when((Object)url.toString()).thenReturn((Object)name);
        return path;
    }
}

