/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz;

import de.skuzzle.tinyplugz.Main;
import de.skuzzle.tinyplugz.PluginSource;
import de.skuzzle.tinyplugz.PluginSourceBuilder;
import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.TinyPlugzException;
import de.skuzzle.tinyplugz.test.util.MockUtil;
import de.skuzzle.tinyplugz.util.ElementIterator;
import java.util.Collections;
import java.util.Optional;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServiceLoader.class, MockUtil.class})
public abstract class AbstractTinyPlugzTest {
    protected static void noPlugins(PluginSourceBuilder source) {
    }

    protected AbstractTinyPlugzTest() {
    }

    @Before
    public void setUp() throws TinyPlugzException {
        ClassLoader parent = this.getClass().getClassLoader();
        this.getSubject().initialize(PluginSource.empty(), parent, Collections.emptyMap());
    }

    protected abstract TinyPlugz getSubject();

    protected abstract <T> void mockService(Class<T> var1, T ... var2);

    @SafeVarargs
    protected final <T> void defaultMockService(Class<T> service, T ... impls) {
        MockUtil.mockService(service, impls);
    }

    @Test
    public void testInitialized() throws Exception {
        Assert.assertNotNull((Object)this.getSubject().getClassLoader());
    }

    @Test
    public void testGetServices() throws Exception {
        SampleService impl1 = (SampleService)PowerMockito.mock(SampleService.class);
        SampleService impl2 = (SampleService)PowerMockito.mock(SampleService.class);
        this.mockService(SampleService.class, impl1, impl2);
        ElementIterator it = this.getSubject().getServices(SampleService.class);
        Assert.assertSame((Object)impl1, it.next());
        Assert.assertSame((Object)impl2, it.next());
    }

    @Test
    public void testGetServicesEmpty() throws Exception {
        this.mockService(SampleService.class, new SampleService[0]);
        ElementIterator it = this.getSubject().getServices(SampleService.class);
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testGetFirstServiceEmpty() throws Exception {
        this.mockService(SampleService.class, new SampleService[0]);
        Optional it = this.getSubject().getFirstService(SampleService.class);
        Assert.assertFalse((boolean)it.isPresent());
    }

    @Test
    public void testGetFirstService() throws Exception {
        SampleService impl1 = (SampleService)PowerMockito.mock(SampleService.class);
        SampleService impl2 = (SampleService)PowerMockito.mock(SampleService.class);
        this.mockService(SampleService.class, impl1, impl2);
        Optional it = this.getSubject().getFirstService(SampleService.class);
        Assert.assertSame((Object)impl1, it.get());
    }

    @Test
    public void testIsServiceAvailableNoService() throws Exception {
        this.mockService(SampleService.class, new SampleService[0]);
        Assert.assertFalse((boolean)this.getSubject().isServiceAvailable(SampleService.class));
    }

    @Test
    public void testIsServiceAvailable() throws Exception {
        SampleService impl1 = (SampleService)PowerMockito.mock(SampleService.class);
        this.mockService(SampleService.class, impl1);
        Assert.assertTrue((boolean)this.getSubject().isServiceAvailable(SampleService.class));
    }

    @Test(expected=RuntimeException.class)
    public void testGetServiceMultipleServices() throws Exception {
        SampleService impl1 = (SampleService)PowerMockito.mock(SampleService.class);
        SampleService impl2 = (SampleService)PowerMockito.mock(SampleService.class);
        this.mockService(SampleService.class, impl1, impl2);
        this.getSubject().getService(SampleService.class);
    }

    @Test(expected=RuntimeException.class)
    public void testGetServiceNoServices() throws Exception {
        this.mockService(SampleService.class, new SampleService[0]);
        this.getSubject().getService(SampleService.class);
    }

    @Test
    public void testGetService() throws Exception {
        SampleService impl1 = (SampleService)PowerMockito.mock(SampleService.class);
        this.mockService(SampleService.class, impl1);
        SampleService service = (SampleService)this.getSubject().getService(SampleService.class);
        Assert.assertSame((Object)impl1, (Object)service);
    }

    @Test
    public void testRunMain() throws Exception {
        String name = "de.skuzzle.tinyplugz.Main";
        this.getSubject().runMain("de.skuzzle.tinyplugz.Main", new String[0]);
        Assert.assertTrue((boolean)Main.called);
    }

    public static interface SampleService {
        public void callMe();
    }
}

