/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import de.skuzzle.tinyplugz.DeployListener;
import de.skuzzle.tinyplugz.PluginInformation;
import de.skuzzle.tinyplugz.PluginSource;
import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.guice.DefaultInjectorFactory;
import de.skuzzle.tinyplugz.guice.GetServicesStrategy;
import de.skuzzle.tinyplugz.guice.InjectorFactory;
import de.skuzzle.tinyplugz.guice.TinyPlugzContext;
import de.skuzzle.tinyplugz.guice.TinyPlugzContextInterceptor;
import de.skuzzle.tinyplugz.internal.DelegateClassLoader;
import de.skuzzle.tinyplugz.internal.ServiceLoaderWrapper;
import de.skuzzle.tinyplugz.util.ElementIterator;
import de.skuzzle.tinyplugz.util.Iterators;
import de.skuzzle.tinyplugz.util.ReflectionUtil;
import de.skuzzle.tinyplugz.util.Require;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TinyPlugzGuice
extends TinyPlugz {
    public static final String ADDITIONAL_MODULES = "tinyplugz.guice.additionalModules";
    public static final String PARENT_INJECTOR = "tinyplugz.guice.parentInjector";
    public static final String INJECTOR_FACTORY = "tinyplugz.guice.injectorFactory";
    public static final String LAZY_SERVICES = "tinyplugz.guice.lazyServices";
    public static final String PLUGIN_CLASSLOADER = "pluginClassLoader";
    private static final Logger LOG = LoggerFactory.getLogger(TinyPlugzGuice.class);
    private Injector injector;
    private GetServicesStrategy getServiceStrategy;
    private DelegateClassLoader pluginClassLoader;
    private ServiceLoaderWrapper serviceLoader;

    @Deprecated
    public TinyPlugzGuice() {
    }

    protected final void initialize(PluginSource source, ClassLoader parentClassLoader, Map<Object, Object> properties) {
        this.getServiceStrategy = this.getGetServiceStrategy(properties);
        LOG.debug("Service strategy: {}", (Object)this.getServiceStrategy);
        this.pluginClassLoader = this.createClassLoader(source, parentClassLoader);
        this.serviceLoader = properties.containsKey("tinyplugz.serviceLoaderWrapper") ? (ServiceLoaderWrapper)ReflectionUtil.createInstance((Object)properties.get("tinyplugz.serviceLoaderWrapper"), ServiceLoaderWrapper.class, (ClassLoader)parentClassLoader) : ServiceLoaderWrapper.getDefault();
        Iterable<Module> appModules = this.getAdditionalModules(properties);
        Iterable<Module> pluginModules = this.getPluginModules();
        Iterable<Module> internal = this.getInternalModule();
        Iterable modules = Iterators.composite((Iterable[])new Iterable[]{internal, appModules, pluginModules});
        this.injector = this.createInjector(properties, modules);
    }

    private GetServicesStrategy getGetServiceStrategy(Map<Object, Object> props) {
        if (props.containsKey(LAZY_SERVICES)) {
            return GetServicesStrategy.LAZY;
        }
        return GetServicesStrategy.EAGER;
    }

    public final Collection<PluginInformation> getPluginInformation() {
        return this.pluginClassLoader.getInformation();
    }

    protected final Iterator<DeployListener> findDeployListeners(ClassLoader pluginClassLoader) {
        ElementIterator listeners = this.serviceLoader.loadService(DeployListener.class, pluginClassLoader);
        return new Iterator<DeployListener>((Iterator)listeners){
            final /* synthetic */ Iterator val$listeners;
            {
                this.val$listeners = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$listeners.hasNext();
            }

            @Override
            public DeployListener next() {
                DeployListener listener = (DeployListener)this.val$listeners.next();
                TinyPlugzGuice.this.injector.injectMembers((Object)listener);
                return listener;
            }
        };
    }

    protected final void dispose() {
        this.defaultDispose();
    }

    private Iterable<Module> getInternalModule() {
        AbstractModule internal = new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(TinyPlugzContext.class), new MethodInterceptor[]{new TinyPlugzContextInterceptor()});
                this.bind(TinyPlugz.class).toInstance((Object)TinyPlugzGuice.this);
                this.bind(ClassLoader.class).annotatedWith((Annotation)Names.named((String)TinyPlugzGuice.PLUGIN_CLASSLOADER)).toInstance((Object)TinyPlugzGuice.this.pluginClassLoader);
                Collection infos = TinyPlugzGuice.this.pluginClassLoader.getInformation();
                for (PluginInformation info : infos) {
                    String name = info.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    if (name == null) continue;
                    this.bind(PluginInformation.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)info);
                }
            }
        };
        return Collections.singleton(internal);
    }

    private Injector createInjector(Map<Object, Object> props, Iterable<Module> modules) {
        InjectorFactory factory;
        Object value = props.get(INJECTOR_FACTORY);
        if (value == null) {
            factory = new DefaultInjectorFactory();
        } else {
            ClassLoader applicationCl = this.pluginClassLoader.getParent();
            factory = (InjectorFactory)ReflectionUtil.createInstance((Object)value, InjectorFactory.class, (ClassLoader)applicationCl);
        }
        Injector guiceInjector = factory.createInjector(modules, props);
        Require.nonNullResult((Object)guiceInjector, (String)"InjectorFactory.createInjector");
        return guiceInjector;
    }

    private Iterable<Module> getAdditionalModules(Map<Object, Object> props) {
        return props.getOrDefault(ADDITIONAL_MODULES, Collections.emptyList());
    }

    private Iterable<Module> getPluginModules() {
        ElementIterator moduleIt = this.serviceLoader.loadService(Module.class, (ClassLoader)this.pluginClassLoader);
        Iterator<Module> wrapped = new Iterator<Module>((Iterator)moduleIt){
            final /* synthetic */ Iterator val$moduleIt;
            {
                this.val$moduleIt = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$moduleIt.hasNext();
            }

            @Override
            public Module next() {
                Module module = (Module)this.val$moduleIt.next();
                LOG.debug("Installing module '{}'", (Object)module);
                return module;
            }
        };
        return Iterators.iterableOf((Iterator)wrapped);
    }

    public final void runMain(String className, String[] args) {
        Require.nonNull((Object)className, (String)"className");
        Require.nonNull((Object)args, (String)"args");
        this.defaultRunMain(className, args);
    }

    public final ClassLoader getClassLoader() {
        return this.pluginClassLoader;
    }

    public final Optional<URL> getResource(String name) {
        Require.nonNull((Object)name, (String)"name");
        return this.defaultGetResource(name);
    }

    public final ElementIterator<URL> getResources(String name) throws IOException {
        Require.nonNull((Object)name, (String)"name");
        return this.defaultGetResources(name);
    }

    public final <T> ElementIterator<T> getServices(Class<T> type) {
        Require.nonNull(type, (String)"type");
        Iterator<T> services = this.getServiceStrategy.getServices(this.injector, type);
        return ElementIterator.wrap(services);
    }

    public final <T> Optional<T> getFirstService(Class<T> type) {
        Require.nonNull(type, (String)"type");
        return this.defaultGetFirstService(type);
    }

    public final <T> T getService(Class<T> type) {
        Require.nonNull(type, (String)"type");
        return (T)this.defaultGetService(type);
    }
}

