/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.guice;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import de.skuzzle.tinyplugz.util.ElementIterator;
import de.skuzzle.tinyplugz.util.Iterators;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum GetServicesStrategy {
    EAGER{

        @Override
        <T> Iterator<T> getServices(Injector injector, Class<T> type) {
            try {
                TypeLiteral<Collection<T>> t = this.setOf(type);
                Collection c = (Collection)injector.getInstance(Key.get(t));
                if (c.isEmpty()) {
                    LOG.trace("Empty multi binding found for '{}'", type);
                    return this.getSingleEager(injector, type);
                }
                return c.iterator();
            }
            catch (ConfigurationException e) {
                LOG.trace("No multi binding found for '{}'", type, (Object)e);
                return this.getSingleEager(injector, type);
            }
        }
    }
    ,
    LAZY{

        @Override
        <T> Iterator<T> getServices(Injector injector, Class<T> type) {
            try {
                TypeLiteral<Collection<Provider<T>>> t = this.setOfProviderOf(type);
                Collection c = (Collection)injector.getInstance(Key.get(t));
                if (c.isEmpty()) {
                    LOG.trace("Empty multi binding found for '{}'", type);
                    return this.getSingleLazy(injector, type);
                }
                return new ProviderIterator(c.iterator());
            }
            catch (ConfigurationException e) {
                LOG.trace("No multi binding found for '{}'", type, (Object)e);
                return this.getSingleLazy(injector, type);
            }
        }
    };

    private static final Logger LOG;

    abstract <T> Iterator<T> getServices(Injector var1, Class<T> var2);

    protected <T> Iterator<T> getSingleEager(Injector injector, Class<T> type) {
        try {
            Object single = injector.getInstance(type);
            return Iterators.singleIterator((Object)single);
        }
        catch (ConfigurationException e) {
            LOG.trace("No binding found for '{}'", type, (Object)e);
            return Collections.emptyIterator();
        }
    }

    protected <T> Iterator<T> getSingleLazy(Injector injector, Class<T> type) {
        try {
            Provider single = injector.getProvider(type);
            Iterator providerIt = Iterators.singleIterator((Object)single);
            return new ProviderIterator(providerIt);
        }
        catch (ConfigurationException e) {
            LOG.trace("No binding found for '{}'", type, (Object)e);
            return Collections.emptyIterator();
        }
    }

    protected <T> TypeLiteral<Collection<T>> setOf(Class<T> type) {
        ParameterizedType providerSet = Types.setOf(type);
        return TypeLiteral.get((Type)providerSet);
    }

    protected <T> TypeLiteral<Collection<Provider<T>>> setOfProviderOf(Class<T> type) {
        ParameterizedType providerType = Types.providerOf(type);
        ParameterizedType providerSet = Types.newParameterizedType(Collection.class, (Type[])new Type[]{providerType});
        return TypeLiteral.get((Type)providerSet);
    }

    static {
        LOG = LoggerFactory.getLogger(GetServicesStrategy.class);
    }

    private static final class ProviderIterator<T>
    implements ElementIterator<T> {
        private final Iterator<Provider<T>> wrapped;

        private ProviderIterator(Iterator<Provider<T>> wrapped) {
            this.wrapped = wrapped;
        }

        public final boolean hasNext() {
            return this.wrapped.hasNext();
        }

        public final T next() {
            return (T)this.wrapped.next().get();
        }
    }
}

