/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import de.skuzzle.tinyplugz.AbstractTinyPlugzTest;
import de.skuzzle.tinyplugz.PluginSource;
import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.TinyPlugzException;
import de.skuzzle.tinyplugz.guice.TinyPlugzGuice;
import de.skuzzle.tinyplugz.internal.ServiceLoaderWrapper;
import de.skuzzle.tinyplugz.util.ElementIterator;
import javax.inject.Inject;
import javax.inject.Named;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TinyPlugzGuiceTest
extends AbstractTinyPlugzTest {
    private final TinyPlugzGuice subject = new TinyPlugzGuice();

    protected TinyPlugz getSubject() {
        return this.subject;
    }

    public void setUp() throws TinyPlugzException {
        this.mockServiceLoader = (ServiceLoaderWrapper)Mockito.mock(ServiceLoaderWrapper.class);
    }

    @SafeVarargs
    protected final <T> void mockService(final Class<T> service, final T ... impls) {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), (Class)service);
                for (Object t : impls) {
                    binder.addBinding().toInstance(t);
                }
            }
        };
        this.defaultMockService(Module.class, new Module[]{module});
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        this.subject.initialize(PluginSource.empty(), parent, this.getInitParams());
    }

    @Test
    public void testInitialized() throws Exception {
        this.mockService(Module.class, new Module[0]);
        Assert.assertNotNull((Object)this.subject.getClassLoader());
    }

    @Test
    public void testRunMain() throws Exception {
        this.mockService(Module.class, new Module[0]);
        super.testRunMain();
    }

    @Test
    public void loadServiceNoMultiBindings() throws Exception {
        final AbstractTinyPlugzTest.SampleService impl = (AbstractTinyPlugzTest.SampleService)Mockito.mock(AbstractTinyPlugzTest.SampleService.class);
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.bind(AbstractTinyPlugzTest.SampleService.class).toInstance((Object)impl);
            }
        };
        this.defaultMockService(Module.class, new Module[]{module});
        ClassLoader mockCL = (ClassLoader)Mockito.mock(ClassLoader.class);
        this.subject.initialize(PluginSource.empty(), mockCL, this.getInitParams());
        ElementIterator provider = this.subject.getServices(AbstractTinyPlugzTest.SampleService.class);
        Assert.assertSame((Object)impl, provider.next());
    }

    @Test
    public void testGetInjector() throws Exception {
        this.mockService(Module.class, new Module[0]);
        Injector injector = (Injector)this.subject.getService(Injector.class);
        Assert.assertNotNull((Object)injector);
    }

    @Test
    public void testGetDefaultBindings() throws Exception {
        this.mockService(Module.class, new Module[0]);
        TestDefaultInjections inst = (TestDefaultInjections)this.subject.getService(TestDefaultInjections.class);
        Assert.assertSame((Object)this.subject, (Object)inst.tinyPlugz);
        Assert.assertSame((Object)this.subject.getClassLoader(), (Object)inst.classLoader);
        Assert.assertNotNull((Object)inst.injector);
    }

    private static class TestDefaultInjections {
        @Inject
        private TinyPlugz tinyPlugz;
        @Inject
        @Named(value="pluginClassLoader")
        private ClassLoader classLoader;
        @Inject
        private Injector injector;

        private TestDefaultInjections() {
        }
    }
}

