/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.guice;

import com.google.inject.Injector;
import de.skuzzle.tinyplugz.PluginSourceBuilder;
import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.TinyPlugzConfigurator;
import de.skuzzle.tinyplugz.guice.TinyPlugzGuiceServletContextListener;
import java.nio.file.Path;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TinyPlugzGuiceServletContextListenerTest {
    @Mock
    private TinyPlugz tinyPlugz;
    @Mock
    private Injector injector;
    @Mock
    private ServletContext context;
    @Mock
    private ServletContextEvent contextEvent;
    @Mock
    private Path webInfDir;
    private TinyPlugzGuiceServletContextListener subject;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.contextEvent.getServletContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.context.getRealPath("WEB-INF")).thenReturn((Object)"WEB-INF");
        this.subject = new TinyPlugzGuiceServletContextListener(){

            protected TinyPlugzConfigurator.DeployTinyPlugz configure(TinyPlugzConfigurator.DefineProperties props, ServletContext context) {
                return props.withPlugins(PluginSourceBuilder::noPlugins);
            }
        };
    }

    @Test
    public void testContextInitialized() throws Exception {
        this.subject.contextInitialized(this.contextEvent);
        Assert.assertNotNull((Object)this.subject.getInjector());
    }

    @Test(expected=IllegalStateException.class)
    public void testContextDestroyed() throws Exception {
        this.subject.contextInitialized(this.contextEvent);
        this.subject.contextDestroyed(this.contextEvent);
        this.subject.getInjector();
    }
}

