/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import de.skuzzle.tinyplugz.guice.DefaultInjectorFactory;
import de.skuzzle.tinyplugz.guice.InjectorFactory;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Guice.class})
public class DefaultInjectorFactoryTest {
    private final InjectorFactory subject = new DefaultInjectorFactory();

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testWithParent() throws Exception {
        Injector injector = (Injector)Mockito.mock(Injector.class);
        Injector child = (Injector)Mockito.mock(Injector.class);
        Mockito.when((Object)injector.createChildInjector(Collections.emptyList())).thenReturn((Object)child);
        HashMap<String, Injector> props = new HashMap<String, Injector>();
        props.put("tinyplugz.guice.parentInjector", injector);
        Injector result = this.subject.createInjector(Collections.emptyList(), props);
        Assert.assertSame((Object)child, (Object)result);
    }

    @Test
    public void testWithoutParent() throws Exception {
        Injector injector = (Injector)Mockito.mock(Injector.class);
        PowerMockito.mockStatic(Guice.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Guice.createInjector(Collections.emptyList())).thenReturn((Object)injector);
        Injector result = this.subject.createInjector(Collections.emptyList(), Collections.emptyMap());
        Assert.assertSame((Object)injector, (Object)result);
    }
}

