/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml.xmlunit;

import de.skuzzle.test.snapshots.ComparisonRuleBuilder;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.data.xml.xmlunit.XPathDebug;
import de.skuzzle.test.snapshots.data.xml.xmlunit.XmlUnitComparisonRuleBuilder;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.Map;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.xmlunit.assertj.CompareAssert;
import org.xmlunit.assertj.XmlAssert;

@API(status=API.Status.INTERNAL, since="1.5.0")
public final class XmlUnitStructuralAssertions
implements StructuralAssertions {
    private final Consumer<ComparisonRuleBuilder> rules;
    private final Consumer<CompareAssert> compareAssertConsumer;
    private final Map<String, String> namespaceContext;
    private final XPathDebug xPathDebug;

    public XmlUnitStructuralAssertions(Consumer<CompareAssert> compareAssertConsumer, Consumer<ComparisonRuleBuilder> rules, Map<String, String> namespaceContext, XPathDebug xPathDebug) {
        this.rules = rules;
        this.compareAssertConsumer = (Consumer)Arguments.requireNonNull(compareAssertConsumer, (String)"compareAssertConsumer must not be null");
        this.xPathDebug = (XPathDebug)Arguments.requireNonNull((Object)xPathDebug, (String)"xPathDebug must not be null");
        this.namespaceContext = namespaceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertEquals(String storedSnapshot, String serializedActual) {
        CompareAssert compareAssert = XmlAssert.assertThat((Object)serializedActual).and((Object)storedSnapshot);
        if (this.rules != null) {
            XmlUnitComparisonRuleBuilder comparisonRuleBuilder = new XmlUnitComparisonRuleBuilder(this.namespaceContext, this.xPathDebug);
            this.rules.accept(comparisonRuleBuilder);
            compareAssert = compareAssert.withDifferenceEvaluator(comparisonRuleBuilder.build());
        }
        if (this.namespaceContext != null) {
            compareAssert.withNamespaceContext(this.namespaceContext);
        }
        try {
            this.compareAssertConsumer.accept(compareAssert);
        }
        catch (Throwable throwable) {
            this.xPathDebug.log("%nPrevious lines were printed because XPath debugging is enabled. It has been enabled at%n%s%n%n", this.xPathDebug.enabledAt);
            throw throwable;
        }
        this.xPathDebug.log("%nPrevious lines were printed because XPath debugging is enabled. It has been enabled at%n%s%n%n", this.xPathDebug.enabledAt);
    }
}

