/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml.xmlunit;

import de.skuzzle.test.snapshots.ComparisonRuleBuilder;
import de.skuzzle.test.snapshots.data.xml.xmlunit.CustomRuleType;
import de.skuzzle.test.snapshots.data.xml.xmlunit.XPathDebug;
import de.skuzzle.test.snapshots.data.xml.xmlunit.XPathDifferenceEvaluator;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.w3c.dom.Node;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.xpath.JAXPXPathEngine;
import org.xmlunit.xpath.XPathEngine;

@API(status=API.Status.INTERNAL, since="1.5.0")
public final class XmlUnitComparisonRuleBuilder
implements ComparisonRuleBuilder {
    private final XPathDebug xPathDebug;
    private final JAXPXPathEngine xpathEngine = new JAXPXPathEngine();
    private final List<DifferenceEvaluator> customizations = new ArrayList<DifferenceEvaluator>();

    public XmlUnitComparisonRuleBuilder(Map<String, String> namespaceContext, XPathDebug xPathDebug) {
        this.xPathDebug = (XPathDebug)Arguments.requireNonNull((Object)xPathDebug);
        if (namespaceContext != null) {
            this.xpathEngine.setNamespaceContext(namespaceContext);
        }
    }

    public ComparisonRuleBuilder.ChooseMatcher pathAt(final String path) {
        Arguments.requireNonNull((Object)path, (String)"path must not be null");
        return new ComparisonRuleBuilder.ChooseMatcher(){

            public ComparisonRuleBuilder mustMatch(Pattern regex) {
                Arguments.requireNonNull((Object)regex, (String)"regex must not be null");
                return this.mustMatchWithInfo(actualDetails -> regex.matcher(((Node)actualDetails).getTextContent()).matches(), "must match pattern: " + regex, CustomRuleType.CUSTOM_MATCH);
            }

            public ComparisonRuleBuilder ignore() {
                return this.mustMatchWithInfo(actualDetails -> true, "will be ignored", CustomRuleType.IGNORE);
            }

            public ComparisonRuleBuilder mustMatch(Predicate<? super Object> predicate) {
                Arguments.requireNonNull(predicate, (String)"predicate must not be null");
                return this.mustMatchWithInfo(predicate, "must match custom predicate: " + predicate, CustomRuleType.CUSTOM_MATCH);
            }

            private ComparisonRuleBuilder mustMatchWithInfo(Predicate<? super Object> predicate, String info, CustomRuleType ruleType) {
                Arguments.requireNonNull(predicate, (String)"predicate must not be null");
                XmlUnitComparisonRuleBuilder.this.customizations.add(new XPathDifferenceEvaluator(ruleType, info, XmlUnitComparisonRuleBuilder.this.xPathDebug, (XPathEngine)XmlUnitComparisonRuleBuilder.this.xpathEngine, path, predicate));
                return XmlUnitComparisonRuleBuilder.this;
            }
        };
    }

    public DifferenceEvaluator build() {
        ArrayList<DifferenceEvaluator> differenceEvaluators = new ArrayList<DifferenceEvaluator>();
        differenceEvaluators.add(DifferenceEvaluators.Default);
        differenceEvaluators.addAll(this.customizations);
        return DifferenceEvaluators.chain((DifferenceEvaluator[])((DifferenceEvaluator[])differenceEvaluators.toArray(DifferenceEvaluator[]::new)));
    }
}

