/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xmlunit;

import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Node;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.xpath.XPathEngine;

final class XPathDifferenceEvaluator
implements DifferenceEvaluator {
    private final boolean enableXPathDebugging;
    private final String xPath;
    private final XPathEngine xPathEngine;
    private final DifferenceEvaluator matchedXPathDelegate;
    private Set<Node> matchedNodes;

    public XPathDifferenceEvaluator(boolean enableXPathDebugging, XPathEngine xPathEngine, String xPath, DifferenceEvaluator matchedXPathDelegate) {
        this.enableXPathDebugging = enableXPathDebugging;
        this.xPath = xPath;
        this.xPathEngine = xPathEngine;
        this.matchedXPathDelegate = matchedXPathDelegate;
    }

    public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
        Comparison.Detail actualDetails = comparison.getTestDetails();
        Node targetNode = actualDetails.getTarget();
        if (!this.isMatchedByXpath(targetNode, this.xPath)) {
            return outcome;
        }
        if (this.enableXPathDebugging) {
            System.out.println("Applying custom comparison rule to node: " + targetNode);
        }
        return this.matchedXPathDelegate.evaluate(comparison, outcome);
    }

    private boolean isMatchedByXpath(Node node, String xPath) {
        if (this.matchedNodes == null) {
            Node root = node.getOwnerDocument() == null ? node : node.getOwnerDocument();
            Iterable selectedNodes = this.xPathEngine.selectNodes(xPath, root);
            HashSet<Node> nodes = new HashSet<Node>();
            selectedNodes.forEach(nodes::add);
            this.matchedNodes = nodes;
            if (this.enableXPathDebugging) {
                System.out.printf("Xpath '%s' matched:%n", xPath);
                this.matchedNodes.forEach(System.out::println);
            }
        }
        return this.matchedNodes.contains(node);
    }
}

