/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xmlunit;

import de.skuzzle.test.snapshots.ComparisonRuleBuilder;
import de.skuzzle.test.snapshots.data.xmlunit.XPathDifferenceEvaluator;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.xpath.JAXPXPathEngine;
import org.xmlunit.xpath.XPathEngine;

@API(status=API.Status.INTERNAL, since="1.5.0")
public final class XmlUnitComparisonRuleBuilder
implements ComparisonRuleBuilder {
    private final JAXPXPathEngine xpathEngine = new JAXPXPathEngine();
    private final List<DifferenceEvaluator> customizations = new ArrayList<DifferenceEvaluator>();

    public ComparisonRuleBuilder.ChooseMatcher pathAt(final String path) {
        Arguments.requireNonNull((Object)path, (String)"path must not be null");
        return new ComparisonRuleBuilder.ChooseMatcher(){

            public ComparisonRuleBuilder mustMatch(Pattern regex) {
                Arguments.requireNonNull((Object)regex, (String)"regex must not be null");
                return this.mustMatch((? super Object actualDetails) -> regex.matcher(((Comparison.Detail)actualDetails).getTarget().getTextContent()).matches());
            }

            public ComparisonRuleBuilder ignore() {
                return this.mustMatch((? super Object actualDetails) -> true);
            }

            public ComparisonRuleBuilder mustMatch(final Predicate<? super Object> predicate) {
                Arguments.requireNonNull(predicate, (String)"predicate must not be null");
                XmlUnitComparisonRuleBuilder.this.customizations.add(new XPathDifferenceEvaluator((XPathEngine)XmlUnitComparisonRuleBuilder.this.xpathEngine, path, new DifferenceEvaluator(){

                    public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                        Comparison.Detail actualDetails = comparison.getTestDetails();
                        return predicate.test(actualDetails) ? ComparisonResult.EQUAL : ComparisonResult.DIFFERENT;
                    }
                }));
                return XmlUnitComparisonRuleBuilder.this;
            }
        };
    }

    public DifferenceEvaluator build() {
        return DifferenceEvaluators.chain((DifferenceEvaluator[])((DifferenceEvaluator[])this.customizations.toArray(DifferenceEvaluator[]::new)));
    }
}

