/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml.xmlunit;

import de.skuzzle.test.snapshots.data.xml.xmlunit.CachedXPath;
import de.skuzzle.test.snapshots.data.xml.xmlunit.CustomRuleType;
import de.skuzzle.test.snapshots.data.xml.xmlunit.XPathDebug;
import java.util.function.Predicate;
import org.w3c.dom.Node;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.xpath.XPathEngine;

final class XPathDifferenceEvaluator
implements DifferenceEvaluator {
    private final XPathDebug xPathDebug;
    private final String info;
    private final CachedXPath cachedXPath;
    private final CustomRuleType ruleType;
    private final Predicate<? super Object> predicate;

    XPathDifferenceEvaluator(CustomRuleType ruleType, String info, XPathDebug xPathDebug, XPathEngine xPathEngine, String xPath, Predicate<? super Object> predicate) {
        this.ruleType = ruleType;
        this.info = info;
        this.xPathDebug = xPathDebug;
        this.predicate = predicate;
        this.cachedXPath = new CachedXPath(xPath, xPathEngine, xPathDebug);
    }

    public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
        if (this.ruleType == CustomRuleType.IGNORE && outcome != ComparisonResult.DIFFERENT) {
            return outcome;
        }
        Comparison.Detail actualDetails = comparison.getTestDetails();
        Node targetNode = actualDetails.getTarget();
        if (!this.cachedXPath.isMatched(targetNode)) {
            return outcome;
        }
        ComparisonResult comparisonResult = this.predicate.test(targetNode) ? ComparisonResult.EQUAL : ComparisonResult.DIFFERENT;
        this.xPathDebug.log("Applying custom comparison rule to node at %s: %s %s. Result: %s", actualDetails.getXPath(), targetNode, this.info, comparisonResult);
        return comparisonResult;
    }
}

