/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml.xmlunit;

import de.skuzzle.test.snapshots.data.xml.xmlunit.XPathDebug;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Node;
import org.xmlunit.xpath.XPathEngine;

final class CachedXPath {
    private final String xPath;
    private final XPathEngine xPathEngine;
    private final XPathDebug xPathDebug;
    private Node rootNode;
    private Set<Node> matchedNodes;

    CachedXPath(String xPath, XPathEngine xPathEngine, XPathDebug xPathDebug) {
        this.xPath = xPath;
        this.xPathEngine = xPathEngine;
        this.xPathDebug = xPathDebug;
    }

    boolean isMatched(Node node) {
        Node rootNode = CachedXPath.getRootNode(node);
        if (this.matchedNodes == null) {
            this.rootNode = rootNode;
            this.matchedNodes = this.executeXPath(node, this.xPath, this.xPathEngine, this.xPathDebug);
        }
        Arguments.check((boolean)this.rootNode.equals(rootNode), (String)"Found that CachedXPath has been applied to two different documents");
        return this.matchedNodes.contains(node);
    }

    private Set<Node> executeXPath(Node node, String xPath, XPathEngine xPathEngine, XPathDebug xPathDebug) {
        Node root = CachedXPath.getRootNode(node);
        Iterable selectedNodes = xPathEngine.selectNodes(xPath, root);
        HashSet<Node> nodes = new HashSet<Node>();
        selectedNodes.forEach(nodes::add);
        if (xPathDebug.enabled) {
            xPathDebug.log("XPath '%s' matched:", xPath);
            if (nodes.isEmpty()) {
                xPathDebug.log("    <none>", new Object[0]);
            }
            nodes.stream().map(Object::toString).map(s -> "    " + s).forEach(x$0 -> xPathDebug.log((String)x$0, new Object[0]));
        }
        return nodes;
    }

    private static Node getRootNode(Node node) {
        return node.getOwnerDocument() == null ? node : node.getOwnerDocument();
    }
}

