/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.release.test;

import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.xml.XmlSnapshot;
import de.skuzzle.test.snapshots.directoryparams.FilesFrom;
import de.skuzzle.test.snapshots.directoryparams.PathFilter;
import de.skuzzle.test.snapshots.directoryparams.TestFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.w3c.dom.Node;
import org.xmlunit.assertj.MultipleNodeAssert;
import org.xmlunit.assertj.XmlAssert;
import org.xmlunit.xpath.JAXPXPathEngine;
import org.xmlunit.xpath.XPathEngine;

@EnableSnapshotTests
public class FilesAreProperlyProcessedTest {
    private static final String EXPECTED_GROUP_ID = "de.skuzzle.test";
    private static final Pattern MAVEN_VERSION = Pattern.compile("\\d+\\.\\d+\\.\\d+(-\\w+)?");
    private static final String XPATH_DESCRIPTION = FilesAreProperlyProcessedTest.xpath("project", "description") + "/text()";
    private static final String XPATH_NAME = FilesAreProperlyProcessedTest.xpath("project", "name") + "/text()";
    private static final String XPATH_URL = FilesAreProperlyProcessedTest.xpath("project", "url") + "/text()";
    private static final String XPATH_LICENSE = FilesAreProperlyProcessedTest.xpath("project", "licenses", "license");
    private static final String XPATH_DEVELOPER = FilesAreProperlyProcessedTest.xpath("project", "developers", "developer");
    private static final String XPATH_VERSION = "//*[local-name()='version']/text()";
    private static final String XPATH_GROUP_ID = "//*[local-name()='groupId']/text()";
    final XPathEngine xpath = new JAXPXPathEngine();

    private static String xpath(String ... path) {
        return "/" + Arrays.stream(path).map(segment -> String.format("*[local-name()='%s']", segment)).collect(Collectors.joining("/"));
    }

    @ParameterizedTest
    @FilesFrom(projectDirectory="../", recursive=true, filter=FlattenedPoms.class)
    void testFlattendPomsContainAllRequiredInformationForSonatype(TestFile testFile) throws IOException {
        ((MultipleNodeAssert)XmlAssert.assertThat((Object)testFile.asText()).nodesByXPath(XPATH_NAME).isNotEmpty()).allSatisfy(node -> Assertions.assertThat((String)node.getTextContent()).isNotEmpty());
        ((MultipleNodeAssert)XmlAssert.assertThat((Object)testFile.asText()).nodesByXPath(XPATH_DESCRIPTION).isNotEmpty()).allSatisfy(node -> Assertions.assertThat((String)node.getTextContent()).isNotEmpty());
        ((MultipleNodeAssert)XmlAssert.assertThat((Object)testFile.asText()).nodesByXPath(XPATH_URL).isNotEmpty()).allSatisfy(node -> Assertions.assertThat((String)node.getTextContent()).isNotEmpty());
        XmlAssert.assertThat((Object)testFile.asText()).nodesByXPath(XPATH_DEVELOPER).isNotEmpty();
        XmlAssert.assertThat((Object)testFile.asText()).nodesByXPath(XPATH_LICENSE).isNotEmpty();
    }

    @ParameterizedTest
    @FilesFrom(projectDirectory="../", recursive=false, extensions={"md"})
    void testPlaceholderResolvedInReadmeFiles(TestFile readmeOrReleaseNotes) throws Exception {
        String contents = readmeOrReleaseNotes.asText();
        Assertions.assertThat((String)contents).doesNotContain(new CharSequence[]{"${project.version}"});
        Assertions.assertThat((String)contents).doesNotContain(new CharSequence[]{"${version.junit}"});
    }

    @Test
    void testBomFilePlaceholdersResolved(SnapshotDsl.Snapshot snapshot) throws Exception {
        Path flattenedPom = this.resolveMavenModule("snapshot-tests-bom").resolve(".flattened-pom.xml");
        String flattenedPomContents = Files.readString(flattenedPom);
        snapshot.assertThat((Object)flattenedPomContents).as((StructuredDataProvider)XmlSnapshot.xml().withPrettyPrintStringXml(false).withComparisonRules(rules -> rules.pathAt(XPATH_GROUP_ID).mustMatch(this.nodeText(EXPECTED_GROUP_ID)).pathAt(XPATH_VERSION).mustMatch(MAVEN_VERSION))).matchesSnapshotStructure();
    }

    private Predicate<? super Object> nodeText(String text) {
        return node -> ((Node)node).getTextContent().equals(text);
    }

    private Path resolveMavenModule(String moduleName) throws IOException {
        return Path.of("..", moduleName).toRealPath(new LinkOption[0]);
    }

    private static final class FlattenedPoms
    implements PathFilter {
        private FlattenedPoms() {
        }

        public boolean include(Path path) throws IOException {
            return path.getFileName().toString().equals(".flattened-pom.xml");
        }
    }
}

