/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.normalize;

import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.3.0")
public final class StringNormalization
implements Function<String, String> {
    private final List<Function<String, String>> modifications = new ArrayList<Function<String, String>>();

    private StringNormalization(Collection<? extends Function<String, String>> modifications) {
        this.modifications.addAll(modifications);
    }

    @SafeVarargs
    public static StringNormalization withModifications(Function<String, String> ... modifications) {
        Arguments.requireNonNull(modifications, (String)"modifications must not be null");
        return new StringNormalization(Arrays.asList(modifications));
    }

    public static StringNormalization withModifications(Collection<? extends Function<String, String>> modifications) {
        Arguments.requireNonNull(modifications, (String)"modifications must not be null");
        return new StringNormalization(modifications);
    }

    public StringNormalization addModification(Function<String, String> modification) {
        this.modifications.add((Function)Arguments.requireNonNull(modification, (String)"modification must not be null"));
        return this;
    }

    @Override
    public String apply(String s) {
        String s1 = (String)Arguments.requireNonNull((Object)s, (String)"string must not be null");
        for (Function<String, String> mod : this.modifications) {
            s1 = mod.apply(s1);
        }
        return s1;
    }
}

