/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.normalize;

import de.skuzzle.test.snapshots.normalize.ObjectMember;
import de.skuzzle.test.snapshots.normalize.ObjectMemberAction;
import de.skuzzle.test.snapshots.normalize.ObjectMembers;
import de.skuzzle.test.snapshots.normalize.VisitorContext;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class ObjectTraversal {
    public static void applyActions(Object root, ObjectMembers strategy, ObjectMemberAction ... actions) {
        ObjectTraversal.applyActions(root, strategy, Arrays.asList(actions));
    }

    public static void applyActions(Object root, ObjectMembers strategy, Collection<ObjectMemberAction> actions) {
        Stream<ObjectMember> members = ObjectTraversal.members(root, strategy);
        for (ObjectMemberAction action2 : actions) {
            members = action2.applyTo(members);
        }
        members.forEach(action -> {});
    }

    public static Stream<ObjectMember> members(Object root, ObjectMembers strategy) {
        Arguments.requireNonNull((Object)strategy, (String)"strategy must not be null");
        VisitorContext context = new VisitorContext();
        return ObjectTraversal.membersOfRecursive(root, null, context, strategy).filter(member -> !context.isTerminal(member.parent()) || member instanceof TerminalTypeInCollection).sorted(Comparator.comparing(ObjectMember::name));
    }

    private static Stream<ObjectMember> membersOfRecursive(Object root, Object collectionParent, VisitorContext context, ObjectMembers strategy) {
        return Stream.of(root).flatMap(start -> ObjectTraversal.membersOf(start, collectionParent, context, strategy)).flatMap(member -> Stream.concat(Stream.of(member), ObjectTraversal.membersOfRecursive(member.value(), collectionParent, context, strategy)));
    }

    private static Stream<ObjectMember> membersOf(Object root, Object collectionParent, VisitorContext context, ObjectMembers strategy) {
        if (root == null || !context.alreadyVisisted(root)) {
            return Stream.empty();
        }
        if (root instanceof Collection) {
            Collection c = (Collection)root;
            return c.stream().flatMap(element -> ObjectTraversal.membersOfRecursive(element, c, context, strategy));
        }
        if (root.getClass().isArray() && !root.getClass().getComponentType().isPrimitive()) {
            Object[] c = (Object[])root;
            return Arrays.stream(c).flatMap(element -> ObjectTraversal.membersOfRecursive(element, c, context, strategy));
        }
        if (root instanceof Iterable) {
            Iterable it = (Iterable)root;
            Spliterator spliterator = it.spliterator();
            return StreamSupport.stream(spliterator, false).flatMap(element -> ObjectTraversal.membersOfRecursive(element, spliterator, context, strategy));
        }
        if (root instanceof Map) {
            Map map = (Map)root;
            return Stream.concat(ObjectTraversal.membersOfRecursive(map.keySet(), collectionParent, context, strategy), ObjectTraversal.membersOfRecursive(map.values(), collectionParent, context, strategy));
        }
        if (context.isTerminal(root)) {
            if (collectionParent != null) {
                return Stream.of(new TerminalTypeInCollection(root, collectionParent));
            }
            return Stream.empty();
        }
        return strategy.directMembersOf(root, collectionParent, context);
    }

    private static final class TerminalTypeInCollection
    implements ObjectMember {
        private final Object value;
        private final Object collectionParent;

        public TerminalTypeInCollection(Object value, Object collectionParent) {
            this.value = Arguments.requireNonNull((Object)value);
            this.collectionParent = Arguments.requireNonNull((Object)collectionParent);
        }

        @Override
        public Object parent() {
            return this.collectionParent;
        }

        @Override
        public Optional<Object> collectionParent() {
            return Optional.of(this.collectionParent);
        }

        @Override
        public String name() {
            return this.value.toString();
        }

        @Override
        public Class<?> valueType() {
            return this.value.getClass();
        }

        @Override
        public Object value() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
        }

        @Override
        public boolean isReadonly() {
            return true;
        }

        @Override
        public boolean isWriteOnly() {
            return false;
        }

        public int hashCode() {
            return Objects.hash(System.identityHashCode(this.value), System.identityHashCode(this.collectionParent));
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof TerminalTypeInCollection && this.value == ((TerminalTypeInCollection)obj).value && this.collectionParent == ((TerminalTypeInCollection)obj).collectionParent;
        }

        public String toString() {
            return String.format("Terminal in %s->[%s]%s: %s", this.collectionParent.getClass().getSimpleName(), this.valueType().getName(), this.name(), "" + this.value());
        }
    }
}

