/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.normalize;

import de.skuzzle.test.snapshots.normalize.ObjectMember;
import de.skuzzle.test.snapshots.normalize.ObjectMembers;
import de.skuzzle.test.snapshots.normalize.Reflection;
import de.skuzzle.test.snapshots.normalize.VisitorContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

class FieldObjectMembers
implements ObjectMembers {
    private static final ObjectMembers INSTANCE = new FieldObjectMembers();

    private FieldObjectMembers() {
    }

    public static ObjectMembers getInstance() {
        return INSTANCE;
    }

    @Override
    public Stream<ObjectMember> directMembersOf(Object root, Object collectionParent, VisitorContext visitorContext) {
        Class<?> valueType = root.getClass();
        return Reflection.superClassHierarchy(valueType).map(Class::getDeclaredFields).flatMap(Arrays::stream).filter(field -> !Modifier.isStatic(field.getModifiers())).map(field -> new FieldObjectMember((Field)field, root, collectionParent));
    }

    private static final class FieldObjectMember
    implements ObjectMember {
        private final Object parent;
        private final Object collectionParent;
        private final Field field;

        public FieldObjectMember(Field field, Object parent, Object collectionParent) {
            this.parent = parent;
            this.collectionParent = collectionParent;
            this.field = field;
        }

        @Override
        public Object parent() {
            return this.parent;
        }

        @Override
        public Optional<Object> collectionParent() {
            return Optional.ofNullable(this.collectionParent);
        }

        @Override
        public Class<?> valueType() {
            return this.field.getType();
        }

        @Override
        public boolean hasTypeCompatibleTo(Class<?> type) {
            return type.isAssignableFrom(this.valueType());
        }

        @Override
        public String name() {
            return this.field.getName();
        }

        @Override
        public Object value() {
            try {
                this.field.setAccessible(true);
                return this.field.get(this.parent);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new UnsupportedOperationException(String.format("Could not read value of field '%s' from object '%s'", this.field, this.parent), e);
            }
        }

        @Override
        public void setValue(Object value) {
            if (this.isReadonly()) {
                return;
            }
            try {
                this.field.setAccessible(true);
                this.field.set(this.parent, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new UnsupportedOperationException(String.format("Could not set value of field '%s' on object '%s' to '%s'", this.field, this.parent, value), e);
            }
        }

        @Override
        public boolean isReadonly() {
            return Modifier.isFinal(this.field.getModifiers());
        }

        @Override
        public boolean isWriteOnly() {
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.field, System.identityHashCode(this.parent));
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof FieldObjectMember && this.parent == ((FieldObjectMember)obj).parent && Objects.equals(this.field, ((FieldObjectMember)obj).field);
        }

        private String valueAsString() {
            Object value = this.value();
            if (value == null) {
                return null;
            }
            if (value.getClass().isArray()) {
                return "[Array]";
            }
            return "" + value;
        }

        public String toString() {
            return String.format("%s->[%s]%s: %s", this.parent.getClass().getSimpleName(), this.valueType().getName(), this.name(), this.valueAsString());
        }
    }
}

