/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.normalize;

import de.skuzzle.test.snapshots.normalize.ObjectMember;
import de.skuzzle.test.snapshots.normalize.SpecialTypesAndValues;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class ObjectMemberAction {
    private final Predicate<ObjectMember> predicate;
    private final Consumer<ObjectMember> action;

    private ObjectMemberAction(Predicate<ObjectMember> predicate, Consumer<ObjectMember> action) {
        this.predicate = predicate;
        this.action = action;
    }

    public static ChoosePredicateBuilder members() {
        return new ChoosePredicateBuilder();
    }

    Stream<ObjectMember> applyTo(Stream<ObjectMember> stream) {
        return stream.peek(objectMember -> {
            if (this.predicate.test((ObjectMember)objectMember)) {
                this.action.accept((ObjectMember)objectMember);
            }
        });
    }

    public static class ChooseActionBuilder {
        private final Predicate<ObjectMember> predicate;

        private ChooseActionBuilder(Predicate<ObjectMember> predicate) {
            this.predicate = (Predicate)Arguments.requireNonNull(predicate, (String)"predicate must not be null");
        }

        public ObjectMemberAction consumeWith(Consumer<ObjectMember> action) {
            return new ObjectMemberAction(this.predicate, (Consumer)Arguments.requireNonNull(action, (String)"action must not be null"));
        }

        public ObjectMemberAction mapValueTo(Function<? super Object, ? extends Object> transformer) {
            return this.consumeWith(objectMember -> objectMember.setValue(transformer.apply(objectMember.value())));
        }

        public ObjectMemberAction setValueTo(Object value) {
            return this.consumeWith(objectMember -> objectMember.setValue(value));
        }

        public ObjectMemberAction setValueToNull() {
            return this.setValueTo(null);
        }

        public ObjectMemberAction setToEmptyValue() {
            return this.consumeWith(objectMember -> {
                Object emptyValue = SpecialTypesAndValues.getEmptyValueForType(objectMember.valueType());
                if (emptyValue != null) {
                    objectMember.setValue(emptyValue);
                }
            });
        }

        public ObjectMemberAction removeFromParent() {
            return this.consumeWith(objectMember -> {
                Object containerCollection = objectMember.collectionParent().orElse(null);
                if (containerCollection == null) {
                    objectMember.setValue(null);
                } else if (containerCollection instanceof Collection) {
                    ((Collection)containerCollection).remove(objectMember.parent());
                }
            });
        }

        public ObjectMemberAction consistentlyReplaceWith(BiFunction<Integer, ? super Object, ? extends Object> generator) {
            HashMap replacements = new HashMap();
            return this.consumeWith(objectMember -> {
                Object value = objectMember.value();
                Object replacement = replacements.computeIfAbsent(replacements, key -> generator.apply(replacements.size(), value));
                objectMember.setValue(replacement);
            });
        }
    }

    public static class ChoosePredicateBuilder {
        public ChooseActionBuilder withValueTypeCompatibleTo(Class<?> type) {
            return this.where(objectMember -> objectMember.hasTypeCompatibleTo(type));
        }

        public ChooseActionBuilder withValueEqualTo(Object obj) {
            return this.where(objectMember -> Objects.equals(obj, objectMember.value()));
        }

        public ChooseActionBuilder withStringValueMatching(Pattern pattern) {
            return this.where(objectMember -> objectMember.hasTypeCompatibleTo(String.class) && objectMember.value() != null && pattern.matcher(objectMember.value().toString()).matches());
        }

        public ChooseActionBuilder withStringValueMatching(String pattern) {
            return this.withStringValueMatching(Pattern.compile(pattern));
        }

        public ChooseActionBuilder any() {
            return this.where(objectMember -> true);
        }

        public ChooseActionBuilder where(Predicate<ObjectMember> predicate) {
            return new ChooseActionBuilder(predicate);
        }
    }
}

