/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.normalize;

import de.skuzzle.test.snapshots.normalize.ObjectMember;
import de.skuzzle.test.snapshots.normalize.ObjectMembers;
import de.skuzzle.test.snapshots.normalize.Reflection;
import de.skuzzle.test.snapshots.normalize.VisitorContext;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MethodObjectMembers
implements ObjectMembers {
    private final Function<Method, PropertyConventions> conventionsConstructor;

    private MethodObjectMembers(Function<Method, PropertyConventions> conventionsConstructor) {
        this.conventionsConstructor = (Function)Arguments.requireNonNull(conventionsConstructor, (String)"conventionsConstructor must not be null");
    }

    public static ObjectMembers usingJavaBeansConventions() {
        return new MethodObjectMembers(JavaBeansPropertyConventions::new);
    }

    public static ObjectMembers using(Function<Method, PropertyConventions> conventionsConstructor) {
        return new MethodObjectMembers(conventionsConstructor);
    }

    @Override
    public Stream<ObjectMember> directMembersOf(Object root, Object collectionParent, VisitorContext visitorContext) {
        Class<?> valueType = root.getClass();
        return Reflection.superClassHierarchy(valueType).map(Class::getDeclaredMethods).flatMap(Arrays::stream).filter(method -> !Modifier.isStatic(method.getModifiers())).map(this.conventionsConstructor).filter(PropertyConventions::includeInTraversal).collect(Collectors.groupingBy(PropertyConventions::canonicalName, MethodObjectMembers.toMethodObjectMember(root, collectionParent))).values().stream().map(ObjectMember.class::cast);
    }

    private static Collector<PropertyConventions, ?, MethodObjectMember> toMethodObjectMember(Object root, Object collectionParent) {
        final class GetterAndSetter {
            private String canonicalName;
            private Method getter;
            private Method setter;

            GetterAndSetter() {
            }
        }
        return Collector.of(() -> new GetterAndSetter(), (getterAndSetter, property) -> {
            getterAndSetter.canonicalName = property.canonicalName();
            if (property.isGetter()) {
                getterAndSetter.getter = property.method();
            } else {
                getterAndSetter.setter = property.method();
            }
        }, (gas1, gas2) -> gas1, gas -> new MethodObjectMember(gas.canonicalName, root, collectionParent, gas.getter, gas.setter), new Collector.Characteristics[0]);
    }

    private static final class MethodObjectMember
    implements ObjectMember {
        private final String name;
        private final Object parent;
        private final Object collectionParent;
        private final Method getter;
        private final Method setter;

        private MethodObjectMember(String name, Object parent, Object collectionParent, Method getter, Method setter) {
            this.name = (String)Arguments.requireNonNull((Object)name, (String)"member name must not be null");
            this.parent = Arguments.requireNonNull((Object)parent, (String)"member's parent must not be null");
            this.collectionParent = collectionParent;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public Object parent() {
            return this.parent;
        }

        @Override
        public Optional<Object> collectionParent() {
            return Optional.ofNullable(this.collectionParent);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<?> valueType() {
            if (this.getter != null) {
                return this.getter.getReturnType();
            }
            return this.setter.getParameterTypes()[0];
        }

        @Override
        public Object value() {
            if (this.isWriteOnly()) {
                return null;
            }
            try {
                this.getter.setAccessible(true);
                return this.getter.invoke(this.parent, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new UnsupportedOperationException(String.format("Could not read value of getter '%s' from object '%s'", this.getter, this.parent), e);
            }
        }

        @Override
        public void setValue(Object value) {
            if (this.isReadonly()) {
                return;
            }
            try {
                this.setter.setAccessible(true);
                this.setter.invoke(this.parent, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new UnsupportedOperationException(String.format("Could not set value of setter '%s' on object '%s' to '%s'", this.setter, this.parent, value), e);
            }
        }

        @Override
        public boolean isReadonly() {
            return this.setter == null;
        }

        @Override
        public boolean isWriteOnly() {
            return this.getter == null;
        }

        public int hashCode() {
            return Objects.hash(this.name, System.identityHashCode(this.parent));
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MethodObjectMember && this.parent == ((MethodObjectMember)obj).parent && Objects.equals(this.name, ((MethodObjectMember)obj).name);
        }

        public String toString() {
            return String.format("%s->[%s]%s: %s", this.parent.getClass().getSimpleName(), this.valueType().getName(), this.name(), "" + this.value());
        }
    }

    private static class JavaBeansPropertyConventions
    implements PropertyConventions {
        private final Method method;

        public JavaBeansPropertyConventions(Method method) {
            this.method = method;
        }

        @Override
        public Method method() {
            return this.method;
        }

        @Override
        public boolean isGetter() {
            String name = this.method.getName();
            return this.method.getParameterCount() == 0 && (name.startsWith("get") && name.length() > 3 && !name.equals("getClass") || name.startsWith("is") && name.length() > 2);
        }

        @Override
        public boolean isSetter() {
            String name = this.method.getName();
            return this.method.getParameterCount() == 1 && name.startsWith("set") && name.length() > 3;
        }

        private int prefixLength() {
            String name = this.method.getName();
            return name.startsWith("is") ? 2 : 3;
        }

        @Override
        public String canonicalName() {
            return this.lowerCaseFirstChar(this.method.getName().substring(this.prefixLength()));
        }

        private String lowerCaseFirstChar(String s) {
            StringBuilder builder = new StringBuilder(s);
            builder.setCharAt(0, Character.toLowerCase(s.charAt(0)));
            return builder.toString();
        }
    }

    public static interface PropertyConventions {
        public Method method();

        public boolean isGetter();

        public boolean isSetter();

        default public boolean includeInTraversal() {
            return this.isGetter() || this.isSetter();
        }

        public String canonicalName();
    }
}

