/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.normalize;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.BiFunction;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public class Generators {
    public static BiFunction<Integer, Object, String> uuidLike() {
        return (i, match) -> {
            String hex = Integer.toHexString(i);
            return "00000000-0000-0000-0000-" + "0".repeat(12 - hex.length()) + hex;
        };
    }

    public static BiFunction<Integer, String, String> dateLike(DateTimeFormatter formatter) {
        return (i, match) -> {
            long millis = 31536000000L * (long)i.intValue();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
            return formatter.format(zonedDateTime);
        };
    }
}

