/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.normalize;

import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.normalize.Generators;
import de.skuzzle.test.snapshots.normalize.ObjectMemberAction;
import de.skuzzle.test.snapshots.normalize.ObjectMembers;
import de.skuzzle.test.snapshots.normalize.ObjectTraversal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@EnableSnapshotTests(forceUpdateSnapshots=false)
public class ObjectTraversalTest {
    private static Stream<Arguments> strategies() {
        return Stream.of(ObjectMembers.usingJavaBeansConventions(), ObjectMembers.fieldBased()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"strategies"})
    void testTraverseSingle(ObjectMembers strategy, SnapshotDsl.Snapshot snapshot) throws Exception {
        Person person = this.determinePerson();
        String result = ObjectTraversal.members((Object)person, (ObjectMembers)strategy).map(Object::toString).collect(Collectors.joining("\n"));
        snapshot.named("traverseSingle").assertThat((Object)result).asText().matchesSnapshotText();
    }

    @ParameterizedTest
    @MethodSource(value={"strategies"})
    void testObjectMemberAction(ObjectMembers strategy, SnapshotDsl.Snapshot snapshot) throws Exception {
        Person person = this.determinePerson();
        ObjectTraversal.applyActions((Object)person, (ObjectMembers)strategy, (ObjectMemberAction[])new ObjectMemberAction[]{ObjectMemberAction.members().where(objMember -> objMember.collectionParent().isPresent()).removeFromParent()});
        snapshot.named("testObjectMemberAction").assertThat((Object)person).asText().matchesSnapshotText();
    }

    @ParameterizedTest
    @MethodSource(value={"strategies"})
    void testConsistentlyReplaceUuid(ObjectMembers strategy, SnapshotDsl.Snapshot snapshot) throws Exception {
        Person person = (Person)this.determinePerson().setUuid(UUID.randomUUID().toString());
        ObjectTraversal.applyActions((Object)person, (ObjectMembers)strategy, (ObjectMemberAction[])new ObjectMemberAction[]{ObjectMemberAction.members().withStringValueMatching("[a-f0-9]{8}(-[a-f0-9]{4}){4}[a-f0-9]{8}").consistentlyReplaceWith(Generators.uuidLike())});
        snapshot.named("testConsistentlyReplaceUuid").assertThat((Object)person).asText().matchesSnapshotText();
    }

    private Person determinePerson() {
        return (Person)new Person().setName("Simon").setSurname("Taddiken").setBirthdate(LocalDate.of(1777, 1, 12)).addAddress(new Address().setCity("Bielefeld").setCountry("Germany").setStreet("Gibtsnicht-Stra\u00dfe").setNumber("1337").setZipCode("4711")).addAddress(new Address().setCity("London").setCountry("UK").setStreet("Whatever-Rd").setNumber("42").setZipCode("11833")).setReadonly(true).setId(4711).addAttribute("height", new Attribute("175").addAdditionalValue("cm")).addAttribute("weight", new Attribute("60").addAdditionalValue("tons"));
    }

    static class Attribute {
        private String value;
        private final List<String> additionalValues = new ArrayList<String>();

        public Attribute(String value) {
            this.value = value;
        }

        public Attribute setValue(String value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public Attribute addAdditionalValue(String additionalValue) {
            this.additionalValues.add(additionalValue);
            return this;
        }

        public List<String> getAdditionalValues() {
            return this.additionalValues;
        }

        public String toString() {
            return "{value: " + this.value + ", " + "additionalValues: " + this.additionalValues + "}";
        }
    }

    public static class Entity {
        private int id;
        private String uuid;
        private boolean readonly;
        private final Map<String, Attribute> attributes = new HashMap<String, Attribute>();

        public Entity setId(int id) {
            this.id = id;
            return this;
        }

        public int getId() {
            return this.id;
        }

        public Entity setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public String getUuid() {
            return this.uuid;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public Entity setReadonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public Entity addAttribute(String key, Attribute attribute) {
            this.attributes.put(key, attribute);
            return this;
        }

        public Map<String, Attribute> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return "id: " + this.id + "\n" + "uuid: " + this.uuid + "\n" + "readonly: " + this.readonly + "\n" + "attributes: " + this.attributes + "\n";
        }
    }

    public static class Person
    extends Entity {
        private String name;
        private String surname;
        private LocalDate birthdate;
        private final List<Address> addresses = new ArrayList<Address>();

        public String getName() {
            return this.name;
        }

        public Person setName(String name) {
            this.name = name;
            return this;
        }

        public String getSurname() {
            return this.surname;
        }

        public Person setSurname(String surname) {
            this.surname = surname;
            return this;
        }

        public LocalDate getBirthdate() {
            return this.birthdate;
        }

        public Person setBirthdate(LocalDate birthdate) {
            this.birthdate = birthdate;
            return this;
        }

        public List<Address> getAddresses() {
            return this.addresses;
        }

        public Person addAddress(Address address) {
            this.addresses.add(address);
            return this;
        }

        @Override
        public String toString() {
            return super.toString() + "Name: " + this.name + "\n" + "Surname: " + this.surname + "\n" + "Birthdate: " + this.birthdate + "\n" + "Addresses: " + this.addresses + "\n";
        }
    }

    public static class Address {
        private String street;
        private String number;
        private String zipCode;
        private String city;
        private String country;
        public static String staticConst = "staticConst";

        public static String getStaticValue() {
            return "xyz";
        }

        public String getStreet() {
            return this.street;
        }

        public Address setStreet(String street) {
            this.street = street;
            return this;
        }

        public String getNumber() {
            return this.number;
        }

        public Address setNumber(String number) {
            this.number = number;
            return this;
        }

        public String getZipCode() {
            return this.zipCode;
        }

        public Address setZipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public String getCity() {
            return this.city;
        }

        public Address setCity(String city) {
            this.city = city;
            return this;
        }

        public String getCountry() {
            return this.country;
        }

        public Address setCountry(String country) {
            this.country = country;
            return this;
        }

        public String toString() {
            return "Street: " + this.street + "\n" + "Number: " + this.number + "\n" + "Zip: " + this.zipCode + "\n" + "City: " + this.city + "\n" + "Country: " + this.country + "\n";
        }
    }
}

