/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.normalize;

import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.3.0")
public final class Strings {
    public static Function<String, String> consistentlyReplace(Pattern pattern, BiFunction<Integer, String, String> generator) {
        Arguments.requireNonNull((Object)pattern, (String)"pattern must not be null");
        Arguments.requireNonNull(generator, (String)"generator must not be null");
        return input -> {
            HashMap<String, String> replacements = new HashMap<String, String>();
            StringBuilder result = new StringBuilder(input.length());
            Matcher matcher = pattern.matcher((CharSequence)input);
            while (matcher.find()) {
                String matched = matcher.group();
                String replacement = replacements.computeIfAbsent(matched, key -> (String)generator.apply(replacements.size(), matched));
                matcher.appendReplacement(result, replacement);
            }
            matcher.appendTail(result);
            return result.toString();
        };
    }

    public static Function<String, String> consistentlyReplace(Pattern pattern, Function<Integer, String> generator) {
        Arguments.requireNonNull(generator, (String)"generator must not be null");
        return Strings.consistentlyReplace(pattern, (Integer i, String match) -> (String)generator.apply((Integer)i));
    }
}

