/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.normalize;

import de.skuzzle.test.snapshots.validation.Arguments;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class Generators {
    public static final Pattern UUID = Pattern.compile("[a-f0-9]{8}(-[a-f0-9]{4}){4}[a-f0-9]{8}");

    private Generators() {
    }

    public static Function<Integer, String> constant(String replacement) {
        Arguments.requireNonNull((Object)replacement, (String)"replacement must not be null");
        return counter -> replacement;
    }

    public static Function<Integer, String> deterministicUUID() {
        return counter -> {
            String hex = Integer.toHexString(counter);
            return "00000000-0000-0000-0000-" + "0".repeat(12 - hex.length()) + hex;
        };
    }

    public static Function<Integer, ZonedDateTime> dateLike(ChronoUnit stepWidth) {
        Arguments.requireNonNull((Object)stepWidth, (String)"stepWidth must not be null");
        return counter -> {
            long millis = stepWidth.getDuration().toMillis() * (long)counter.intValue();
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
        };
    }

    public static Function<Integer, String> dateLike(DateTimeFormatter formatter, ChronoUnit stepWidth) {
        Arguments.requireNonNull((Object)formatter, (String)"formatter must not be null");
        return Generators.dateLike(stepWidth).andThen(formatter::format);
    }
}

