/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.normalize;

import de.skuzzle.test.snapshots.normalize.Normalize;
import java.util.UUID;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class NormalizeTest {
    private static final Pattern uuid = Pattern.compile("([a-f0-9]{8}(-[a-f0-9]{4}){4}[a-f0-9]{8})");

    @Test
    void testConsistentlyReplace() throws Exception {
        String uuid0 = UUID.randomUUID().toString();
        String uuid1 = UUID.randomUUID().toString();
        String s = uuid0 + " and " + uuid1 + " and " + uuid1;
        String result = (String)Normalize.consistentlyReplace((Pattern)uuid, (i, m) -> "uuid" + i).apply(s);
        Assertions.assertThat((String)result).isEqualTo("uuid0 and uuid1 and uuid1");
    }
}

