/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.junit4;

import de.skuzzle.test.snapshots.Snapshot;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotNaming;
import de.skuzzle.test.snapshots.impl.SnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.SnapshotTestContext;
import de.skuzzle.test.snapshots.impl.TestFrameworkSupport;
import de.skuzzle.test.snapshots.junit4.CombinedRule;
import de.skuzzle.test.snapshots.junit4.JUnit4TestFrameworkSupport;
import de.skuzzle.test.snapshots.validation.State;
import java.lang.reflect.Method;
import java.nio.file.Path;
import org.apiguardian.api.API;
import org.junit.AssumptionViolatedException;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

@API(status=API.Status.EXPERIMENTAL, since="1.8.0")
public final class SnapshotRule
implements CombinedRule,
Snapshot {
    private SnapshotTestContext context;
    private Snapshot currentSnapshot;

    public static SnapshotRule enableSnapshotTests() {
        return new SnapshotRule();
    }

    private SnapshotRule() {
    }

    private SnapshotTestContext currentContext() {
        State.check((this.context != null ? 1 : 0) != 0, (String)"No SnapshotTestContext found. Make sure that the Rule instance is static and annotated with both @Rule *and* @ClassRule", (Object[])new Object[0]);
        return this.context;
    }

    private Snapshot currentSnapshot() {
        State.check((this.currentSnapshot != null ? 1 : 0) != 0, (String)"There is no current snapshot", (Object[])new Object[0]);
        return this.currentSnapshot;
    }

    private Method getTestMethod(Description description) {
        try {
            return description.getTestClass().getMethod(description.getMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Could not determine test method");
        }
    }

    @Override
    @Deprecated
    @API(status=API.Status.INTERNAL)
    public void beforeClass(Description description) {
        Class testClass = description.getTestClass();
        SnapshotConfiguration configuration = SnapshotConfiguration.defaultConfigurationFor((Class)testClass);
        this.context = SnapshotTestContext.forConfiguration((SnapshotConfiguration)configuration, (TestFrameworkSupport)JUnit4TestFrameworkSupport.INSTANCE);
        new TestClass(testClass).getAnnotatedMethods(Ignore.class).stream().map(FrameworkMethod::getMethod).forEach(arg_0 -> ((SnapshotTestContext)this.context).recordFailedOrSkippedTest(arg_0));
    }

    @Override
    @Deprecated
    @API(status=API.Status.INTERNAL)
    public void afterClass(Description description) {
        this.currentContext().detectOrCleanupOrphanedSnapshots();
    }

    @Override
    @Deprecated
    @API(status=API.Status.INTERNAL)
    public void before(Description description) throws Exception {
        Method testMethod = this.getTestMethod(description);
        this.currentSnapshot = this.currentContext().createSnapshotTestFor(testMethod);
    }

    @Override
    @Deprecated
    @API(status=API.Status.INTERNAL)
    public void after(Description description) throws Exception {
        try {
            this.currentContext().finalizeSnapshotTest();
        }
        catch (AssumptionViolatedException e) {
            this.onSkippedTest(description);
            throw e;
        }
        finally {
            this.currentSnapshot = null;
        }
    }

    @Override
    @Deprecated
    @API(status=API.Status.INTERNAL)
    public void onFailedTest(Description description) {
        Method testMethod = this.getTestMethod(description);
        this.currentContext().recordFailedOrSkippedTest(testMethod);
    }

    @Override
    @Deprecated
    @API(status=API.Status.INTERNAL)
    public void onSkippedTest(Description description) {
        Method testMethod = this.getTestMethod(description);
        this.currentContext().recordFailedOrSkippedTest(testMethod);
    }

    public SnapshotDsl.ChooseDataFormat assertThat(Object actual) {
        return this.currentSnapshot().assertThat(actual);
    }

    public SnapshotDsl.ChooseActual namedAccordingTo(SnapshotNaming namingStrategy) {
        return this.currentSnapshot().namedAccordingTo(namingStrategy);
    }

    public SnapshotDsl.ChooseName in(Path directory) {
        return this.currentSnapshot().in(directory);
    }
}

