/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.junit4;

import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

interface CombinedRule
extends TestRule {
    default public Statement apply(final Statement base, final Description description) {
        if (description.isTest()) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    CombinedRule.this.before(description);
                    try {
                        base.evaluate();
                        CombinedRule.this.verify(description);
                    }
                    catch (AssumptionViolatedException e) {
                        CombinedRule.this.onSkippedTest(description);
                        throw e;
                    }
                    catch (Throwable e) {
                        CombinedRule.this.onFailedTest(description);
                        throw e;
                    }
                    finally {
                        CombinedRule.this.after(description);
                    }
                }
            };
        }
        if (description.isSuite()) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    CombinedRule.this.beforeClass(description);
                    try {
                        base.evaluate();
                        CombinedRule.this.verifyClass(description);
                    }
                    finally {
                        CombinedRule.this.afterClass(description);
                    }
                }
            };
        }
        return base;
    }

    default public void before(Description description) throws Exception {
    }

    default public void after(Description description) throws Exception {
    }

    default public void verify(Description description) {
    }

    default public void beforeClass(Description description) throws Exception {
    }

    default public void afterClass(Description description) throws Exception {
    }

    default public void verifyClass(Description description) {
    }

    default public void onSkippedTest(Description description) {
    }

    default public void onFailedTest(Description description) {
    }
}

