/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

final class StringXmlPrettyPrint {
    private static final TransformerFactory TRANS = TransformerFactory.newInstance();

    StringXmlPrettyPrint() {
    }

    public static String prettyPrint(String doc) {
        try {
            Transformer tf = StringXmlPrettyPrint.createTransformer();
            StreamResult result = new StreamResult(new StringWriter());
            StreamSource source = new StreamSource(new StringReader(doc));
            tf.transform(source, result);
            return result.getWriter().toString().replace("?><", String.format("?>%n<", new Object[0])).replace("\" xmlns:", String.format("\"%n\t\t\txmlns:", new Object[0]));
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Error while pretty printing XML", e);
        }
    }

    private static Transformer createTransformer() throws TransformerException {
        Transformer transformer = TRANS.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }
}

