/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml;

import de.skuzzle.test.snapshots.ComparisonRuleBuilder;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.xml.JaxbXmlSnapshotSerializer;
import de.skuzzle.test.snapshots.data.xml.XmlComparisonRuleBuilder;
import de.skuzzle.test.snapshots.data.xml.XmlUnitStructuralAssertions;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.function.Consumer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apiguardian.api.API;
import org.xmlunit.assertj.CompareAssert;
import org.xmlunit.diff.DifferenceEvaluator;

@API(status=API.Status.STABLE)
public final class XmlSnapshot
implements StructuredDataProvider {
    public static final StructuredDataProvider xml = XmlSnapshot.inferJaxbContext().build();
    private final JAXBContext jaxbContext;
    private MarshallerSupplier marshallerSupplier;
    private Consumer<CompareAssert> compareAssertConsumer = CompareAssert::areIdentical;
    private DifferenceEvaluator differenceEvaluator;

    private XmlSnapshot(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
        this.marshallerSupplier = ctx -> {
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            return marshaller;
        };
    }

    public static XmlSnapshot inferJaxbContext() {
        return new XmlSnapshot(null);
    }

    public static XmlSnapshot with(JAXBContext jaxbContext) {
        return new XmlSnapshot((JAXBContext)Arguments.requireNonNull((Object)jaxbContext, (String)"jaxbContext must not be null"));
    }

    public XmlSnapshot withMarshaller(MarshallerSupplier marshallerSupplier) {
        this.marshallerSupplier = (MarshallerSupplier)Arguments.requireNonNull((Object)marshallerSupplier, (String)"marshallerSupplier must not be null");
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public XmlSnapshot compareUsing(Consumer<CompareAssert> xmls) {
        this.compareAssertConsumer = (Consumer)Arguments.requireNonNull(xmls, (String)"CompareAssert consumer must not be null");
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3.0")
    public XmlSnapshot withComparisonRules(Consumer<ComparisonRuleBuilder> rules) {
        Arguments.requireNonNull(rules, (String)"rules consumer must not be null");
        XmlComparisonRuleBuilder comparatorCustomizerImpl = new XmlComparisonRuleBuilder();
        rules.accept(comparatorCustomizerImpl);
        this.differenceEvaluator = comparatorCustomizerImpl.build();
        return this;
    }

    public StructuredData build() {
        SnapshotSerializer snapshotSerializer = JaxbXmlSnapshotSerializer.withExplicitJaxbContext(this.jaxbContext, this.marshallerSupplier);
        XmlUnitStructuralAssertions structuralAssertions = new XmlUnitStructuralAssertions(this.compareAssertConsumer, this.differenceEvaluator);
        return StructuredData.with((SnapshotSerializer)snapshotSerializer, (StructuralAssertions)structuralAssertions);
    }

    @FunctionalInterface
    static interface MarshallerSupplier {
        public Marshaller createMarshaller(JAXBContext var1) throws JAXBException;
    }
}

