/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml;

import java.util.stream.StreamSupport;
import org.w3c.dom.Node;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.xpath.XPathEngine;

final class XPathDifferenceEvaluator
implements DifferenceEvaluator {
    private final String xPath;
    private final XPathEngine xPathEngine;
    private final DifferenceEvaluator matchedXPathDelegate;

    public XPathDifferenceEvaluator(XPathEngine xPathEngine, String xPath, DifferenceEvaluator matchedXPathDelegate) {
        this.xPath = xPath;
        this.xPathEngine = xPathEngine;
        this.matchedXPathDelegate = matchedXPathDelegate;
    }

    public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
        Comparison.Detail actualDetails = comparison.getTestDetails();
        Node targetNode = actualDetails.getTarget();
        if (!this.isMatchedByXpath(targetNode, this.xPath)) {
            return outcome;
        }
        return this.matchedXPathDelegate.evaluate(comparison, outcome);
    }

    private boolean isMatchedByXpath(Node node, String xPath) {
        Iterable selectedNodes = this.xPathEngine.selectNodes(xPath, node);
        return StreamSupport.stream(selectedNodes.spliterator(), false).anyMatch(node::equals);
    }
}

