/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml;

import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.data.xml.CachedJAXBContexts;
import de.skuzzle.test.snapshots.data.xml.XmlSnapshot;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

final class JaxbXmlSnapshotSerializer
implements SnapshotSerializer {
    private final JAXBContext jaxb;
    private final XmlSnapshot.MarshallerSupplier marshallerSupplier;

    private JaxbXmlSnapshotSerializer(JAXBContext jaxb, XmlSnapshot.MarshallerSupplier marshallerSupplier) {
        this.jaxb = jaxb;
        this.marshallerSupplier = (XmlSnapshot.MarshallerSupplier)Arguments.requireNonNull((Object)marshallerSupplier);
    }

    public static SnapshotSerializer withExplicitJaxbContext(JAXBContext jaxb, XmlSnapshot.MarshallerSupplier marshallerSupplier) {
        return new JaxbXmlSnapshotSerializer(jaxb, marshallerSupplier);
    }

    public static JaxbXmlSnapshotSerializer withAutomaticJaxbContext(XmlSnapshot.MarshallerSupplier marshallerSupplier) {
        return new JaxbXmlSnapshotSerializer(null, marshallerSupplier);
    }

    private JAXBContext inferJaxbContext(Object object) {
        return this.jaxb == null ? CachedJAXBContexts.getOrCreateContext(object) : this.jaxb;
    }

    private Object wrapIntoRootObject(Object testResult) {
        if (testResult.getClass().isAnnotationPresent(XmlRootElement.class) || testResult instanceof JAXBElement) {
            return testResult;
        }
        return new JAXBElement(new QName(testResult.getClass().getSimpleName()), testResult.getClass(), testResult);
    }

    public String serialize(Object testResult) throws SnapshotException {
        try {
            JAXBContext jaxbContext = this.inferJaxbContext(testResult);
            StringWriter writer = new StringWriter();
            Marshaller marshaller = this.marshallerSupplier.createMarshaller(jaxbContext);
            Object wrapped = this.wrapIntoRootObject(testResult);
            marshaller.marshal(wrapped, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new SnapshotException("Error serializing object to XML: " + testResult, (Throwable)e);
        }
    }
}

