/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml;

import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataBuilder;
import de.skuzzle.test.snapshots.data.xml.JaxbXmlSnapshotSerializer;
import de.skuzzle.test.snapshots.data.xml.XmlUnitStructuralAssertions;
import java.util.Objects;
import java.util.function.Consumer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.assertj.core.annotations.Nullable;
import org.xmlunit.assertj.CompareAssert;

public final class XmlSnapshot
implements StructuredDataBuilder {
    public static final StructuredData xml = XmlSnapshot.inferJaxbContext().build();
    @Nullable
    private final JAXBContext jaxbContext;
    private MarshallerSupplier marshallerSupplier;
    private Consumer<CompareAssert> compareAssertConsumer = CompareAssert::areIdentical;

    private XmlSnapshot(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
        this.marshallerSupplier = ctx -> {
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            return marshaller;
        };
    }

    public static XmlSnapshot inferJaxbContext() {
        return new XmlSnapshot(null);
    }

    public static XmlSnapshot with(JAXBContext jaxbContext) {
        return new XmlSnapshot(Objects.requireNonNull(jaxbContext, "jaxbContext must not be null"));
    }

    public XmlSnapshot withMarshaller(MarshallerSupplier marshallerSupplier) {
        this.marshallerSupplier = Objects.requireNonNull(marshallerSupplier, "marshallerSupplier must not be null");
        return this;
    }

    public XmlSnapshot compareUsing(Consumer<CompareAssert> xmls) {
        this.compareAssertConsumer = Objects.requireNonNull(xmls, "CompareAssert consumer must not be null");
        return this;
    }

    public StructuredData build() {
        SnapshotSerializer snapshotSerializer = JaxbXmlSnapshotSerializer.withExplicitJaxbContext(this.jaxbContext, this.marshallerSupplier);
        XmlUnitStructuralAssertions structuralAssertions = new XmlUnitStructuralAssertions(this.compareAssertConsumer);
        return StructuredData.with((SnapshotSerializer)snapshotSerializer, (StructuralAssertions)structuralAssertions);
    }

    @FunctionalInterface
    static interface MarshallerSupplier {
        public Marshaller createMarshaller(JAXBContext var1) throws JAXBException;
    }
}

