/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml;

import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.data.xml.CachedJAXBContexts;
import de.skuzzle.test.snapshots.data.xml.XmlSnapshot;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.assertj.core.annotations.Nullable;

final class JaxbXmlSnapshotSerializer
implements SnapshotSerializer {
    @Nullable
    private final JAXBContext jaxb;
    private final XmlSnapshot.MarshallerSupplier marshallerSupplier;

    private JaxbXmlSnapshotSerializer(JAXBContext jaxb, XmlSnapshot.MarshallerSupplier marshallerSupplier) {
        this.jaxb = jaxb;
        this.marshallerSupplier = Objects.requireNonNull(marshallerSupplier);
    }

    public static SnapshotSerializer withExplicitJaxbContext(@Nullable JAXBContext jaxb, XmlSnapshot.MarshallerSupplier marshallerSupplier) {
        return new JaxbXmlSnapshotSerializer(jaxb, marshallerSupplier);
    }

    public static JaxbXmlSnapshotSerializer withAutomaticJaxbContext(XmlSnapshot.MarshallerSupplier marshallerSupplier) {
        return new JaxbXmlSnapshotSerializer(null, marshallerSupplier);
    }

    private JAXBContext inferJaxbContext(Object object) {
        return this.jaxb == null ? CachedJAXBContexts.getOrCreateContext(object) : this.jaxb;
    }

    public String serialize(Object testResult) throws SnapshotException {
        try {
            JAXBContext jaxbContext = this.inferJaxbContext(testResult);
            StringWriter writer = new StringWriter();
            Marshaller marshaller = this.marshallerSupplier.createMarshaller(jaxbContext);
            marshaller.marshal(testResult, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new SnapshotException("Error serializing object to XML: " + testResult, (Throwable)e);
        }
    }
}

