/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml;

import de.skuzzle.test.snapshots.ComparisonRuleBuilder;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.xml.JaxbXmlSnapshotSerializer;
import de.skuzzle.test.snapshots.data.xmlunit.XmlUnitComparisonRuleBuilder;
import de.skuzzle.test.snapshots.data.xmlunit.XmlUnitStructuralAssertions;
import de.skuzzle.test.snapshots.validation.Arguments;
import de.skuzzle.test.snapshots.validation.State;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.xmlunit.assertj.CompareAssert;
import org.xmlunit.diff.DifferenceEvaluator;

@API(status=API.Status.STABLE, since="1.7.0")
public final class XmlSnapshot
implements StructuredDataProvider {
    public static final StructuredDataProvider xml = XmlSnapshot.xml().build();
    private JAXBContext jaxbContext;
    private MarshallerSupplier marshallerSupplier;
    private Consumer<CompareAssert> compareAssertConsumer = CompareAssert::areIdentical;
    private DifferenceEvaluator differenceEvaluator;
    private boolean prettyPrintStringXml = true;
    private boolean enableXPathDebugging = false;

    private XmlSnapshot() {
        this.marshallerSupplier = ctx -> {
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            return marshaller;
        };
    }

    public static XmlSnapshot xml() {
        return new XmlSnapshot();
    }

    public XmlSnapshot withJAXBContext(JAXBContext jaxbContext) {
        this.jaxbContext = (JAXBContext)Arguments.requireNonNull((Object)jaxbContext, (String)"jaxbContext must not be null");
        return this;
    }

    public XmlSnapshot withMarshaller(MarshallerSupplier marshallerSupplier) {
        this.marshallerSupplier = (MarshallerSupplier)Arguments.requireNonNull((Object)marshallerSupplier, (String)"marshallerSupplier must not be null");
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public XmlSnapshot withPrettyPrintStringXml(boolean prettyPrintStringXml) {
        this.prettyPrintStringXml = prettyPrintStringXml;
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public XmlSnapshot compareUsing(Consumer<CompareAssert> xmls) {
        this.compareAssertConsumer = (Consumer)Arguments.requireNonNull(xmls, (String)"CompareAssert consumer must not be null");
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public XmlSnapshot withEnableXPathDebugging(boolean enableXPathDebugging) {
        State.check((this.differenceEvaluator == null ? 1 : 0) != 0, (String)"xpath debugging must be enabled before specifying custom comparison rules", (Object[])new Object[0]);
        this.enableXPathDebugging = enableXPathDebugging;
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public XmlSnapshot withComparisonRules(Consumer<ComparisonRuleBuilder> rules) {
        Arguments.requireNonNull(rules, (String)"rules consumer must not be null");
        XmlUnitComparisonRuleBuilder comparatorCustomizerImpl = new XmlUnitComparisonRuleBuilder(this.enableXPathDebugging);
        rules.accept((ComparisonRuleBuilder)comparatorCustomizerImpl);
        this.differenceEvaluator = comparatorCustomizerImpl.build();
        return this;
    }

    public StructuredData build() {
        SnapshotSerializer snapshotSerializer = JaxbXmlSnapshotSerializer.withExplicitJaxbContext(this.jaxbContext, this.marshallerSupplier, this.prettyPrintStringXml);
        XmlUnitStructuralAssertions structuralAssertions = new XmlUnitStructuralAssertions(this.compareAssertConsumer, this.differenceEvaluator);
        return StructuredData.with((SnapshotSerializer)snapshotSerializer, (StructuralAssertions)structuralAssertions);
    }

    @FunctionalInterface
    static interface MarshallerSupplier {
        public Marshaller createMarshaller(JAXBContext var1) throws JAXBException;
    }
}

