/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml;

import de.skuzzle.test.snapshots.ComparisonRuleBuilder;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.xml.JaxbXmlSnapshotSerializer;
import de.skuzzle.test.snapshots.data.xml.xmlunit.XPathDebug;
import de.skuzzle.test.snapshots.data.xml.xmlunit.XmlUnitStructuralAssertions;
import de.skuzzle.test.snapshots.reflection.Classes;
import de.skuzzle.test.snapshots.reflection.StackTraces;
import de.skuzzle.test.snapshots.validation.Arguments;
import de.skuzzle.test.snapshots.validation.State;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.util.Map;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.xmlunit.assertj.CompareAssert;

@API(status=API.Status.STABLE, since="1.7.0")
public final class XmlSnapshot
implements StructuredDataProvider {
    @Deprecated(forRemoval=true)
    static final boolean LEGACY_WARNING_PRINTED;
    public static final StructuredDataProvider xml;
    private JAXBContext jaxbContext;
    private MarshallerSupplier marshallerSupplier;
    private Consumer<CompareAssert> compareAssertConsumer = CompareAssert::areIdentical;
    private Consumer<ComparisonRuleBuilder> rules;
    private boolean prettyPrintStringXml = true;
    private XPathDebug xPathDebug = XPathDebug.disabled();
    private Map<String, String> namespaceContext = null;

    private XmlSnapshot() {
        this.marshallerSupplier = ctx -> {
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            return marshaller;
        };
    }

    public static XmlSnapshot xml() {
        return new XmlSnapshot();
    }

    public XmlSnapshot withJAXBContext(JAXBContext jaxbContext) {
        this.jaxbContext = (JAXBContext)Arguments.requireNonNull((Object)jaxbContext, (String)"jaxbContext must not be null");
        return this;
    }

    public XmlSnapshot withMarshaller(MarshallerSupplier marshallerSupplier) {
        this.marshallerSupplier = (MarshallerSupplier)Arguments.requireNonNull((Object)marshallerSupplier, (String)"marshallerSupplier must not be null");
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public XmlSnapshot withPrettyPrintStringXml(boolean prettyPrintStringXml) {
        this.prettyPrintStringXml = prettyPrintStringXml;
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public XmlSnapshot compareUsing(Consumer<CompareAssert> xmls) {
        this.compareAssertConsumer = (Consumer)Arguments.requireNonNull(xmls, (String)"CompareAssert consumer must not be null");
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public XmlSnapshot withEnableXPathDebugging(boolean enableXPathDebugging) {
        State.check((this.rules == null ? 1 : 0) != 0, (String)"xpath debugging must be enabled before specifying custom comparison rules", (Object[])new Object[0]);
        this.xPathDebug = enableXPathDebugging ? XPathDebug.enabledAt((Object)StackTraces.findImmediateCaller()) : XPathDebug.disabled();
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public XmlSnapshot withComparisonRules(Consumer<ComparisonRuleBuilder> rules) {
        Arguments.requireNonNull(rules, (String)"rules consumer must not be null");
        this.rules = rules;
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.9.0")
    public XmlSnapshot withXPathNamespaceContext(Map<String, String> namespaceContext) {
        State.check((this.rules == null ? 1 : 0) != 0, (String)"namespaceContext must be enabled before specifying custom comparison rules", (Object[])new Object[0]);
        this.namespaceContext = (Map)Arguments.requireNonNull(namespaceContext, (String)"namespaceContext must not be null");
        return this;
    }

    public StructuredData build() {
        SnapshotSerializer snapshotSerializer = JaxbXmlSnapshotSerializer.withExplicitJaxbContext(this.jaxbContext, this.marshallerSupplier, this.prettyPrintStringXml);
        XmlUnitStructuralAssertions structuralAssertions = new XmlUnitStructuralAssertions(this.compareAssertConsumer, this.rules, this.namespaceContext, this.xPathDebug);
        return StructuredData.with((SnapshotSerializer)snapshotSerializer, (StructuralAssertions)structuralAssertions);
    }

    static {
        boolean placeHolderAvailable = Classes.isClassPresent((String)"de.skuzzle.test.snapshots.data.xmlx.PlaceHolder");
        if (!placeHolderAvailable) {
            System.err.println("DEPRECATION WARNING: Starting from snapshot-tests version 1.10.0, you should depend on 'snapshot-tests-xml-legacy' module.");
            System.err.println();
            System.err.println("To remove this warning, follow these migration steps:");
            System.err.println();
            System.err.println("- Remove direct dependency to 'snapshot-tests-jaxb'");
            System.err.println("- Add direct dependency to 'snapshot-tests-xml-legacy' instead");
            LEGACY_WARNING_PRINTED = true;
        } else {
            LEGACY_WARNING_PRINTED = false;
        }
        xml = XmlSnapshot.xml().build();
    }

    @FunctionalInterface
    public static interface MarshallerSupplier {
        public Marshaller createMarshaller(JAXBContext var1) throws JAXBException;
    }
}

