/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.xml;

import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.data.xml.CachedJAXBContexts;
import de.skuzzle.test.snapshots.data.xml.StringXmlPrettyPrint;
import de.skuzzle.test.snapshots.data.xml.XmlSnapshot;
import de.skuzzle.test.snapshots.validation.Arguments;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;

final class JaxbXmlSnapshotSerializer
implements SnapshotSerializer {
    private final JAXBContext jaxb;
    private final XmlSnapshot.MarshallerSupplier marshallerSupplier;
    private final boolean prettyPrintXmlStrings;

    private JaxbXmlSnapshotSerializer(JAXBContext jaxb, XmlSnapshot.MarshallerSupplier marshallerSupplier, boolean prettyPrintXmlStrings) {
        this.jaxb = jaxb;
        this.marshallerSupplier = (XmlSnapshot.MarshallerSupplier)Arguments.requireNonNull((Object)marshallerSupplier);
        this.prettyPrintXmlStrings = prettyPrintXmlStrings;
    }

    public static SnapshotSerializer withExplicitJaxbContext(JAXBContext jaxb, XmlSnapshot.MarshallerSupplier marshallerSupplier, boolean prettyPrintXmlStrings) {
        return new JaxbXmlSnapshotSerializer(jaxb, marshallerSupplier, prettyPrintXmlStrings);
    }

    private JAXBContext inferJaxbContext(Object object) {
        return this.jaxb == null ? CachedJAXBContexts.getOrCreateContext(object) : this.jaxb;
    }

    private Object wrapIntoRootObject(Object testResult) {
        if (testResult.getClass().isAnnotationPresent(XmlRootElement.class) || testResult instanceof JAXBElement) {
            return testResult;
        }
        return new JAXBElement(new QName(testResult.getClass().getSimpleName()), testResult.getClass(), testResult);
    }

    public String serialize(Object testResult) throws SnapshotException {
        try {
            if (testResult instanceof String) {
                if (this.prettyPrintXmlStrings) {
                    return StringXmlPrettyPrint.prettyPrint(testResult.toString());
                }
                return testResult.toString();
            }
            JAXBContext jaxbContext = this.inferJaxbContext(testResult);
            StringWriter writer = new StringWriter();
            Marshaller marshaller = this.marshallerSupplier.createMarshaller(jaxbContext);
            Object wrapped = this.wrapIntoRootObject(testResult);
            marshaller.marshal(wrapped, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new SnapshotException("Error serializing object to XML: " + testResult, (Throwable)e);
        }
    }
}

