/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.skuzzle.test.snapshots.ComparisonRuleBuilder;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.json.CompareMode;
import de.skuzzle.test.snapshots.data.json.JacksonJsonSnapshotSerializer;
import de.skuzzle.test.snapshots.data.json.JsonAssertStructuralAssertions;
import de.skuzzle.test.snapshots.data.json.JsonComparisonRuleBuilder;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.skyscreamer.jsonassert.comparator.JSONComparator;

@API(status=API.Status.STABLE)
public final class JsonSnapshot
implements StructuredDataProvider {
    public static final StructuredDataProvider json = JsonSnapshot.json().build();
    private final ObjectMapper objectMapper;
    private CompareMode compareMode = CompareMode.STRICT;
    private JsonComparisonRuleBuilder comparisonRuleBuilder = new JsonComparisonRuleBuilder();
    private JSONComparator jsonComparator;

    private JsonSnapshot(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Arguments.requireNonNull((Object)objectMapper, (String)"objectMapper must not be null");
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="1.4.0")
    public static JsonSnapshot withDefaultObjectMapper() {
        return JsonSnapshot.json();
    }

    public static JsonSnapshot json() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.registerModules(new Module[]{new Jdk8Module(), new JavaTimeModule()});
        return JsonSnapshot.json(objectMapper);
    }

    public static JsonSnapshot json(ObjectMapper objectMapper) {
        return new JsonSnapshot(objectMapper);
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="1.4.0")
    public static JsonSnapshot withObjectMapper(ObjectMapper objectMapper) {
        return new JsonSnapshot(objectMapper);
    }

    public JsonSnapshot configure(Consumer<ObjectMapper> c) {
        Arguments.requireNonNull(c, (String)"consumer must not be null");
        c.accept(this.objectMapper);
        return this;
    }

    @Deprecated(forRemoval=true, since="1.2.0")
    @API(status=API.Status.DEPRECATED, since="1.2.0")
    public JsonSnapshot withComparator(JSONComparator jsonComparator) {
        this.jsonComparator = (JSONComparator)Arguments.requireNonNull((Object)jsonComparator, (String)"comparator must not be null");
        return this;
    }

    @API(status=API.Status.STABLE, since="1.5.0")
    public JsonSnapshot withCompareMode(CompareMode compareMode) {
        this.compareMode = (CompareMode)((Object)Arguments.requireNonNull((Object)((Object)compareMode), (String)"compareMode must not be null"));
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.0")
    public JsonSnapshot withComparisonRules(Consumer<ComparisonRuleBuilder> rules) {
        Arguments.requireNonNull(rules, (String)"rules consumer must not be null");
        JsonComparisonRuleBuilder comparatorCustomizerImpl = new JsonComparisonRuleBuilder();
        rules.accept(comparatorCustomizerImpl);
        this.comparisonRuleBuilder = comparatorCustomizerImpl;
        return this;
    }

    private JSONComparator determineComparator() {
        return this.jsonComparator == null ? this.comparisonRuleBuilder.build(this.compareMode.toJSONCompareMode()) : this.jsonComparator;
    }

    public StructuredData build() {
        JSONComparator comparator = this.determineComparator();
        JacksonJsonSnapshotSerializer snapshotSerializer = new JacksonJsonSnapshotSerializer(this.objectMapper);
        JsonAssertStructuralAssertions structuralAssertions = new JsonAssertStructuralAssertions(comparator);
        return StructuredData.with((SnapshotSerializer)snapshotSerializer, (StructuralAssertions)structuralAssertions);
    }
}

