/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.json.ComparatorCustomizerImpl;
import de.skuzzle.test.snapshots.data.json.ComparisonRuleBuilder;
import de.skuzzle.test.snapshots.data.json.JacksonJsonSnapshotSerializer;
import de.skuzzle.test.snapshots.data.json.JsonAssertStructuralAssertions;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.comparator.DefaultComparator;
import org.skyscreamer.jsonassert.comparator.JSONComparator;

@API(status=API.Status.STABLE)
public final class JsonSnapshot
implements StructuredDataProvider {
    public static final StructuredDataProvider json = JsonSnapshot.withDefaultObjectMapper().build();
    private final ObjectMapper objectMapper;
    private JSONComparator jsonComparator;

    private JsonSnapshot(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Arguments.requireNonNull((Object)objectMapper, (String)"objectMapper must not be null");
        this.jsonComparator = new DefaultComparator(JSONCompareMode.STRICT);
    }

    public static JsonSnapshot withDefaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.registerModules(new Module[]{new Jdk8Module(), new JavaTimeModule()});
        return new JsonSnapshot(objectMapper);
    }

    public static JsonSnapshot withObjectMapper(ObjectMapper objectMapper) {
        return new JsonSnapshot(objectMapper);
    }

    public JsonSnapshot configure(Consumer<ObjectMapper> c) {
        Arguments.requireNonNull(c, (String)"consumer must not be null");
        c.accept(this.objectMapper);
        return this;
    }

    @Deprecated(forRemoval=true, since="1.2.0")
    @API(status=API.Status.DEPRECATED, since="1.2.0")
    public JsonSnapshot withComparator(JSONComparator jsonComparator) {
        this.jsonComparator = (JSONComparator)Arguments.requireNonNull((Object)jsonComparator, (String)"comparator must not be null");
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.0")
    public JsonSnapshot withComparisonRules(Consumer<ComparisonRuleBuilder> rules) {
        ComparatorCustomizerImpl comparatorCustomizerImpl = new ComparatorCustomizerImpl();
        rules.accept(comparatorCustomizerImpl);
        this.jsonComparator = comparatorCustomizerImpl.build();
        return this;
    }

    public StructuredData build() {
        JacksonJsonSnapshotSerializer snapshotSerializer = new JacksonJsonSnapshotSerializer(this.objectMapper);
        JsonAssertStructuralAssertions structuralAssertions = new JsonAssertStructuralAssertions(this.jsonComparator);
        return StructuredData.with((SnapshotSerializer)snapshotSerializer, (StructuralAssertions)structuralAssertions);
    }
}

