/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataBuilder;
import de.skuzzle.test.snapshots.data.json.JacksonJsonSnapshotSerializer;
import de.skuzzle.test.snapshots.data.json.JsonAssertStructuralAssertions;
import java.util.Objects;
import java.util.function.Consumer;

public final class JsonSnapshot
implements StructuredDataBuilder {
    public static final StructuredData json = JsonSnapshot.withDefaultObjectMapper().build();
    private final ObjectMapper objectMapper;

    private JsonSnapshot(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper must not be null");
    }

    public static JsonSnapshot withDefaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.registerModules(new Module[]{new Jdk8Module(), new JavaTimeModule()});
        return new JsonSnapshot(objectMapper);
    }

    public static JsonSnapshot withObjectMapper(ObjectMapper objectMapper) {
        return new JsonSnapshot(objectMapper);
    }

    public JsonSnapshot configure(Consumer<ObjectMapper> c) {
        c.accept(this.objectMapper);
        return this;
    }

    public StructuredData build() {
        JacksonJsonSnapshotSerializer snapshotSerializer = new JacksonJsonSnapshotSerializer(this.objectMapper);
        JsonAssertStructuralAssertions structuralAssertions = new JsonAssertStructuralAssertions();
        return StructuredData.with((SnapshotSerializer)snapshotSerializer, (StructuralAssertions)structuralAssertions);
    }
}

