/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.html;

import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.html.HtmlSnapshot;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@EnableSnapshotTests
public class HtmlSnapshotTests {
    @Test
    void testCompareHtmlPrettyPrinted(SnapshotDsl.Snapshot snapshot) throws Exception {
        SnapshotTestResult result = snapshot.assertThat((Object)"<html><body someAttribute=\"hehe\"><h1>Test</h1></body></html>").as((StructuredDataProvider)HtmlSnapshot.html().withPrettyPrintSnapshot(true)).matchesSnapshotStructure();
        String snapshotText = result.serializedSnapshot().snapshot();
        Assertions.assertThat((String)snapshotText).isEqualTo("<html>\n    <head></head>\n    <body someattribute=\"hehe\">\n        <h1>Test</h1>\n    </body>\n</html>");
    }

    @Test
    void testCompareHtmlWithCustomComparisonRulePattern(SnapshotDsl.Snapshot snapshot) throws Exception {
        snapshot.assertThat((Object)"<html><body><h1>Not_Test</h1></body></html>").as((StructuredDataProvider)HtmlSnapshot.html().withComparisonRules(rules -> rules.pathAt("/html/body/h1/text()").mustMatch(Pattern.compile("\\w+")))).matchesSnapshotStructure();
    }

    @Test
    void testCompareHtmlWithCustomComparisonRuleIgnore(SnapshotDsl.Snapshot snapshot) throws Exception {
        snapshot.assertThat((Object)"<html><body><h1>Test 123</h1></body></html>").as((StructuredDataProvider)HtmlSnapshot.html().withComparisonRules(rules -> rules.pathAt("/html/body/h1/text()").ignore())).matchesSnapshotStructure();
    }
}

