/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.html;

import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.function.Consumer;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.xmlunit.assertj.CompareAssert;
import org.xmlunit.assertj.XmlAssert;
import org.xmlunit.diff.DifferenceEvaluator;

final class HtmlStructuralAssertions
implements StructuralAssertions {
    private final DifferenceEvaluator differenceEvaluator;
    private final Consumer<CompareAssert> compareAssertConsumer;

    public HtmlStructuralAssertions(Consumer<CompareAssert> compareAssertConsumer, DifferenceEvaluator differenceEvaluator) {
        this.differenceEvaluator = differenceEvaluator;
        this.compareAssertConsumer = (Consumer)Arguments.requireNonNull(compareAssertConsumer, (String)"compareAssertConsumer must not be null");
    }

    public void assertEquals(String storedSnapshot, String serializedActual) throws AssertionError, SnapshotException {
        W3CDom w3cDom = new W3CDom();
        Document parsedSnapshot = Jsoup.parse((String)storedSnapshot);
        Document parsedActual = Jsoup.parse((String)serializedActual);
        CompareAssert compareAssert = XmlAssert.assertThat((Object)w3cDom.fromJsoup(parsedSnapshot)).and((Object)w3cDom.fromJsoup(parsedActual));
        if (this.differenceEvaluator != null) {
            compareAssert = compareAssert.withDifferenceEvaluator(this.differenceEvaluator);
        }
        this.compareAssertConsumer.accept(compareAssert);
    }
}

