/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.html;

import de.skuzzle.test.snapshots.ComparisonRuleBuilder;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.html.HtmlSnapshotSerializer;
import de.skuzzle.test.snapshots.data.html.HtmlStructuralAssertions;
import de.skuzzle.test.snapshots.data.xml.xmlunit.XPathDebug;
import de.skuzzle.test.snapshots.data.xml.xmlunit.XmlUnitComparisonRuleBuilder;
import de.skuzzle.test.snapshots.reflection.StackTraces;
import de.skuzzle.test.snapshots.validation.Arguments;
import de.skuzzle.test.snapshots.validation.State;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.xmlunit.assertj.CompareAssert;
import org.xmlunit.diff.DifferenceEvaluator;

@API(status=API.Status.EXPERIMENTAL, since="1.5.0")
public final class HtmlSnapshot
implements StructuredDataProvider {
    public static final StructuredDataProvider html = HtmlSnapshot.html().build();
    private Consumer<CompareAssert> compareAssertConsumer = CompareAssert::areIdentical;
    private DifferenceEvaluator differenceEvaluator;
    private boolean prettyPrintSnapshot = false;
    private XPathDebug xPathDebug = XPathDebug.disabled();

    public static HtmlSnapshot html() {
        return new HtmlSnapshot();
    }

    private HtmlSnapshot() {
    }

    public HtmlSnapshot compareUsing(Consumer<CompareAssert> xmls) {
        this.compareAssertConsumer = (Consumer)Arguments.requireNonNull(xmls, (String)"CompareAssert consumer must not be null");
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.6.0")
    public HtmlSnapshot withEnableXPathDebugging(boolean enableXPathDebugging) {
        State.check((this.differenceEvaluator == null ? 1 : 0) != 0, (String)"xpath debugging must be enabled before specifying custom comparison rules", (Object[])new Object[0]);
        this.xPathDebug = XPathDebug.enabledAt((Object)StackTraces.findImmediateCaller());
        return this;
    }

    public HtmlSnapshot withComparisonRules(Consumer<ComparisonRuleBuilder> rules) {
        Arguments.requireNonNull(rules, (String)"rules consumer must not be null");
        XmlUnitComparisonRuleBuilder comparatorCustomizerImpl = new XmlUnitComparisonRuleBuilder(null, this.xPathDebug);
        rules.accept((ComparisonRuleBuilder)comparatorCustomizerImpl);
        this.differenceEvaluator = comparatorCustomizerImpl.build();
        return this;
    }

    public HtmlSnapshot withPrettyPrintSnapshot(boolean prettyPrintSnapshot) {
        this.prettyPrintSnapshot = prettyPrintSnapshot;
        return this;
    }

    public StructuredData build() {
        HtmlSnapshotSerializer snapshotSerializer = new HtmlSnapshotSerializer(this.prettyPrintSnapshot);
        HtmlStructuralAssertions structuralAssertions = new HtmlStructuralAssertions(this.compareAssertConsumer, this.differenceEvaluator);
        return StructuredData.with((SnapshotSerializer)snapshotSerializer, (StructuralAssertions)structuralAssertions);
    }
}

